<?php
/**
 * The table list class
 * 
 * @link       https://1.envato.market/mgXE4y
 * @since      2.1
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class StreamTube_Core_Bunny_Collections_List_Table extends WP_List_Table {

    private $bunnycdn;

    public function __construct() {
        parent::__construct( array(
            'singular' => esc_html__( 'Video', 'streamtube-core' ),
            'plural'   => esc_html__( 'Videos', 'streamtube-core' ),
            'ajax'     => true
        ) );

        $this->get_instance();
    }

    private function get_instance(){
        $this->bunnycdn = $GLOBALS['streamtube']->get()->bunnycdn;
    }

    public function get_columns() {
        $columns = array(
            'cb'                => '<input type="checkbox" />',
            'user'              => esc_html__( 'User', 'streamtube-core' ),
            'name'              => esc_html__( 'Collection', 'streamtube-core' ),
            'guid'              => esc_html__( 'GUID', 'streamtube-core' ),
            'videoCount'        => esc_html__( 'Videos', 'streamtube-core' ),
            'totalSize'         => esc_html__( 'Size', 'streamtube-core' ),
            'action'            => esc_html__( 'Action', 'streamtube-core' )
        );
        return $columns;
    }

    /**
     * Define what data to show on each column of the table
     *
     * @param  Array $item        Data
     * @param  String $column_name - Current column name
     *
     * @return Mixed
     */
    public function column_default( $item, $column_name ){

        $output = '';

        switch( $column_name ) {

            case 'user':
                $maybe_user_id = $this->bunnycdn->get_user_id_from_collection( $item['guid'] );

                if( $maybe_user_id ){
                    $user = get_userdata( $maybe_user_id );

                    if( $user ){
                        $output = sprintf(
                            '<a class="text-body" href="%s">(#%s %s) %s</a>',
                            esc_url( get_author_posts_url( $maybe_user_id ) ),
                            esc_attr( $maybe_user_id ),
                            esc_attr( $user->user_login ),
                            esc_attr( $user->display_name )
                        );
                    }
                }
            break;

            case 'totalSize':
                $output = size_format( $item[$column_name] );
            break; 

            case 'videoCount':
                $output = number_format_i18n( $item[$column_name], 0 );
            break;             

            case 'action':
                if(  Streamtube_Core_BunnyCDN_Perms::delete_collections() ){
                    $output = sprintf(
                        '<button 
                            type="button" 
                            class="%s" 
                            data-nonce="%s" 
                            data-action="%s" 
                            data-params="%s"
                            data-prompt="%s"
                            data-prompt-value="%s"
                        >%s</button>',
                        esc_attr( 'btn btn-sm bg-danger button button-small text-white delete-bunny-collection ajax-elm' ),
                        esc_attr( wp_create_nonce( 'delete-' . $item['guid'] ) ),
                        esc_attr( 'delete_bunny_collection' ),
                        esc_attr( $item['guid'] ),
                        sprintf(
                            esc_attr__( 'Are you sure you want to permanently delete the %s collection? All videos within this collection will also be permanently deleted and cannot be undone. Please enter the collection GUID to confirm.', 'streamtube-core' ),
                            $item['name']
                        ),
                        esc_attr( $item['guid'] ),
                        esc_html__( 'Delete', 'streamtube-core' )
                    );
                }
            break;

            default:
                $output = $item[ $column_name ];
            break;
        }

        return $output;
    }

    /**
     * Define which columns are hidden
     *
     * @return array
     */
    public function get_hidden_columns() {
        $hidden_columns = (array)get_user_option( 'manage' . $this->screen->id . 'columnshidden' );

        return is_array( $hidden_columns ) ? $hidden_columns : array();
    }

    protected function get_items_per_page( $option = '', $default_value = 20 ) {
        $per_page = (int)get_user_option( 'edit_'. $this->screen->id .'_per_page' );

        return $per_page !== 0 ? absint( $per_page ) : $default_value;
    }

    /**
     * Define the sortable columns
     *
     * @return array
     */
    public function get_sortable_columns() {
        return array(
            'name'          => array( 'name', false ),
            'videoCount'    =>  array( 'videoCount', false ),
            'totalSize'     =>  array( 'totalSize', false )
        );
    }  

    /**
     * Render the bulk edit checkbox
     *
     * @param array $item
     *
     * @return string
     */
    function column_cb( $item ) {
        return sprintf(
            '<input type="checkbox" name="guid[]" value="%s" />', $item['guid']
        );
    }    

    /**
     * Get the table data
     *
     * @return array
     */
    private function table_data() {
        
        $args = array(
            'search'    => isset( $_REQUEST['s'] ) ? wp_unslash( $_REQUEST['s'] ) : '',
            'orderBy'   => 'date'
        );

        if( isset( $_REQUEST['collectionId'] ) ){
            $args['collection'] = wp_unslash( $_REQUEST['collectionId'] );
        }

        $data = $this->bunnycdn->bunnyAPI->get_collections( $args );

        if( is_wp_error( $data ) ){
            return array();
        }

        return $data['items'];
    }

    /**
     * Sort data based on the selected column and order
     *
     * @param array $a
     * @param array $b
     * @return int
     */
    private function sort_data( $a, $b ) {
        $orderby = isset( $_GET['orderby'] ) && is_string( $_GET['orderby'] ) ? sanitize_text_field( $_GET['orderby'] ) : 'videoCount'; 
        $order   = isset( $_GET['order'] ) && is_string( $_GET['order'] ) ? sanitize_text_field( $_GET['order'] ) : 'desc';

        if ( ! is_string( $a[$orderby] ) || ! is_string( $b[$orderby] ) || ! isset( $a[$orderby] ) || ! isset( $b[$orderby] ) ) {
            return 0; // Handle cases where the sort column doesn't exist in the data
        }

        $result = strcmp( $a[$orderby], $b[$orderby] ); 

        return ( $order === 'asc' ) ? $result : -$result;
    }

    public function prepare_items() {
        $columns  = $this->get_columns();
        $hidden   = $this->get_hidden_columns();
        $sortable = $this->get_sortable_columns();

        $data = $this->table_data();
        usort( $data, array( $this, 'sort_data' ) );

        $perPage     = $this->get_items_per_page();
        $currentPage = $this->get_pagenum();
        $totalItems  = count( $data );

        $this->set_pagination_args( array(
            'total_items' => $totalItems,
            'per_page'    => $perPage,
        ) );

        $data = array_slice( $data, ( ( $currentPage - 1 ) * $perPage ), $perPage );

        $this->_column_headers = array( $columns, $hidden, $sortable );
        $this->items = $data;

        $this->process_bulk_action();
    }

    public function process_bulk_action() {

        if( ! current_user_can( 'administrator' ) ){
            return;
        }

    }
}