(function ($) {
    "use strict";

    // Add the filter to change the upload handler dynamically
    wp.hooks.addFilter( 'streamtube_js_do_upload_file_handler', 'bunnycdn', resumableUpload, 20 );  

    const tusEndpoint = "https://video.bunnycdn.com/tusupload";

    function resumableUpload( oldHandler, file, form ) {

        var formData    = new FormData();

        formData.append( 'name',        file.name );
        formData.append( 'size',        file.size );
        formData.append( 'type',        file.type );

        const fileId = $.generateFileId(file);
        var progress = $(`div[data-file-id="${fileId}"]`);

        var jqxhr = $.ajax({
            url             : streamtube.rest_url + '/bunny/token',
            data            : formData,
            processData     : false,
            contentType     : false,
            type            : 'POST',         
            beforeSend: function( jqXHR ) {
                jqXHR.setRequestHeader( 'X-WP-Nonce', streamtube.nonce );
            }
        });

        jqxhr.fail( function( jqXHR, textStatus, errorThrown ){
            if( jqXHR?.responseJSON?.code === 'rest_forbidden' ){
                return $.showToast( jqXHR?.responseJSON?.message, 'danger');
            }

            if ( jqXHR?.responseJSON?.data) {
                $(document.body).trigger('upload_video', [jqXHR.responseJSON, textStatus, jqXHR, file, form]);
            } else {
                const errorMessage = jqXHR?.responseJSON?.message ?? errorThrown ?? textStatus;
                $.showToast(errorMessage, 'danger');
            }
        });

        jqxhr.done( function( data, textStatus, jqXHR ){

            data = data.data;

            const upload = new tus.Upload( file, {
                endpoint: tusEndpoint,            
                retryDelays: [0, 3000, 5000, 10000, 20000, 60000, 60000],
                headers: {
                    AuthorizationSignature: data.sha256.signature,
                    AuthorizationExpire: data.sha256.expiration,
                    VideoId: data.video_id,
                    LibraryId: data.library_id
                },            
                metadata: {
                    filetype: file.type,
                    title: file.name,
                    collection: data.collection
                },
                onError: (error) => {
                    console.error("TUS Upload Error:", error);
                },
                onProgress: (bytesUploaded, bytesTotal) => {

                    const percentComplete = Math.round((bytesUploaded / bytesTotal) * 100);

                    // Update the progress bar UI
                    progress.find('.progress-bar')
                        .css('width', `${percentComplete}%`)
                        .attr('aria-valuenow', percentComplete)
                        .html(`${percentComplete}%`);
                },
                onSuccess: () => {

                    // Notify the server about the successful upload
                    $.ajax({
                        url: streamtube.rest_url + '/bunny/import',
                        type: 'POST',
                        data: {
                            guid: data.video_id,
                            size: file.size,
                            type : file.type,
                            status : form.find( 'select[name=post_status]' ).val()
                        },
                        beforeSend: function(jqXHR) {
                            jqXHR.setRequestHeader( 'X-WP-Nonce', streamtube.nonce );
                        },
                        success: function(data, textStatus, jqXHR) {
                            $(document.body).trigger('upload_video', [data, textStatus, jqXHR, file, form]);
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            $.showToast( textStatus, 'danger' );
                        }
                    });

                }
            });

            upload.start();

        });
    }

    $( document ).on( 'show.bs.modal', '#modal-upload', function(e){

        let modal = $(this);
        modal.find( '.modal-body' ).append( $.getSpinner( true, 'danger', '', '<span class="ms-2">'+ streamtube.preparing_upload +'</span>' ) );
        modal.find( 'form' ).addClass( 'd-none' );

        var jqxhr = $.ajax({
            url             : streamtube.rest_url + '/bunny/collection',
            processData     : false,
            contentType     : false,
            type            : 'POST',         
            beforeSend: function( jqXHR ) {
                jqXHR.setRequestHeader( 'X-WP-Nonce', streamtube.nonce );
            }
        });        

        jqxhr.fail( function( jqXHR, textStatus, errorThrown ){
            $.showToast( errorThrown ?? textStatus, 'danger' );
        });    

        jqxhr.done( function( data, textStatus, jqXHR ){
            if( data.success == false ){
                return $.showToast( data.data[0].message, 'danger' );
            }
        });    

        jqxhr.always( function( jqXHR, textStatus ){
            modal.find( '.spinner-wrap' ).remove();
            modal.find( 'form' ).removeClass( 'd-none' );
        });
    } );

})(jQuery);
