(function ($) {
    "use strict";

    $( document ).on( 'click', 'button.button-bunnycdn-sync', function(e){

        e.preventDefault();

        var button          = $(this);
        var attachmentId    = button.attr( 'data-attachment-id' );

        var formData        = new FormData();

        formData.append( 'attachment_id', attachmentId );
        formData.append( 'action', 'bunnycdn_sync' );
        formData.append( 'nonce', button.attr( 'data-nonce' ) );

        var jqxhr = $.ajax({
            url             : streamtube.ajax_url,
            data            : formData,
            processData     : false,
            contentType     : false,
            type            : 'POST',
            beforeSend: function( jqXHR ) {
                button.addClass('disabled').attr('disabled', 'disabled');

                button.next( '.alert' ).remove();
            }
        })

        .fail( function( jqXHR, textStatus, errorThrown ){
            alert( errorThrown )
        })

        .done( function( response, textStatus, jqXHR ){
            if( response.success == false ){
                button.removeClass('disabled').removeAttr('disabled');

                if( streamtube?.is_admin ){
                    alert( response.data[0].message );    
                }else{
                    $.showToast( response.data, 'danger' );
                }
                
            }else{
                button.html( response.data.message );
            }
        });
    });

    $( document ).on( 'click', 'button.button-bunnycdn-retry', function(e){

        e.preventDefault();

        var button          = $(this);
        var attachmentId    = button.attr( 'data-attachment-id' );

        var formData        = new FormData();

        formData.append( 'attachment_id', attachmentId );
        formData.append( 'action', 'bunnycdn_retry_sync' );

        var jqxhr = $.ajax({
            url             : streamtube.ajax_url,
            data            : formData,
            processData     : false,
            contentType     : false,
            type            : 'POST',
            beforeSend: function( jqXHR ) {
                button.addClass('disabled').attr('disabled', 'disabled');
                button.next( '.alert' ).remove();
            }
        })

        .fail( function( jqXHR, textStatus, errorThrown ){
            alert( errorThrown )
        })

        .done( function( response, textStatus, jqXHR ){
            if( response.success == false ){
                button.removeClass('disabled').removeAttr('disabled');
                button.after( '<p class="alert alert-danger">'+ response.data[0].message +'</p>' );
            }else{
                button.html( response.data.message );
            }
        });
    }); 

    $( document ).on( 'click', 'button.button-import-bunny-video', function(e){
        e.preventDefault();

        var button = $(this);
        var guid = button.attr( 'data-guid' );
        var nonce = button.attr( 'data-nonce' );

        $.ajax( {
            url: streamtube.ajax_url,
            method: 'POST',
            beforeSend: function ( xhr ) {
                button.attr( 'disabled', 'disabled' );
            },
            data:{
                'guid'      : guid,
                'action'    : 'import_bunny_video',
                '_wpnonce'  : nonce
            }
        } ).done( function ( response ) {
            if( response.success == false ){
                alert( response.data[0].message );
            }else{
                button.replaceWith( response.data.badge );
            }
            button.removeAttr( 'disabled' );
        
        } );
    } );

    $( document ).on( 'submit', 'form#import-bunny-all-videos', function(e) {
        e.preventDefault();

        var form        = $(this);
        var button      = form.find('button[type=submit]');
        var progress    = form.find( '.progress-wrap' );
        var list        =   form.find( '#bunny-imported-list' );
        var formData    = new FormData(form[0]);


        if( formData.get('confirm') == 'on' && ! confirm( formData.get( 'confirm_msg' ) ) ){
            return false;
        }

        $.ajax({
            url: streamtube.ajax_url,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function(xhr) {
                button.attr('disabled', 'disabled').addClass( 'd-none' );
                progress.removeClass( 'd-none' );
            },
            success: function(response) {

                form.find( 'input[name=confirm]' ).val( 'off' );

                var storedData          = sessionStorage.getItem('bunny_items');
                storedData              = storedData ? JSON.parse(storedData) : [];

                var totalItems          = storedData.length;
                var storedtotalItems    = sessionStorage.getItem( 'bunny_total_items' );

                if (response.success === true) {
                    var data            = response.data;
                    var didAction       = data.did_action;

                    if( didAction == 'fetched' ){

                        var totalItems      = parseInt( data.totalItems );
                        var itemsPerPage    = parseInt( data.itemsPerPage );
                        var currentPage     = parseInt( data.currentPage );
                        var totalPages      = Math.ceil( totalItems / itemsPerPage );  

                        // Add new items if they exist
                        if ( data.items ) {
                            storedData = storedData.concat(data.items);
                            sessionStorage.setItem('bunny_items', JSON.stringify(storedData));
                        }              

                        storedData = storedData.reduce((acc, current) => {
                            if ( ! acc.some(item => item.guid === current.guid)) {
                                acc.push(current);
                            }
                            return acc;
                        }, []);

                        if( currentPage < totalPages ){
                            form.find( 'input[name=paged]' ).val( currentPage+1 );
                            form.trigger( 'submit' );
                        }
                        else{
                            sessionStorage.setItem( 'bunny_total_items', storedData.length );
                            var entry = storedData.shift();
                            sessionStorage.setItem('bunny_items', JSON.stringify(storedData));
                            form.find( 'input[name=guid]' ).val( entry.guid );
                            form.trigger( 'submit' );
                        }

                        progress
                        .find( '.progress-bar' ).addClass( 'bg-success rounded' )
                        .html( '<span class="text-black" style="padding: 0 1rem;">Preparing ....</span>' );

                    }else{

                        if( storedData.length > 0 ){
                            var entry = storedData.shift();
                            sessionStorage.setItem('bunny_items', JSON.stringify(storedData));
                            form.find( 'input[name=guid]' ).val( entry.guid );
                            form.trigger( 'submit' );
                        }

                        if( list.hasClass( 'd-none' ) ){
                            list.removeClass( 'd-none' );
                        }

                        list.append( '<li class="border-bottom"><a target="_blank" href="'+ response.data.post.url +'">'+ response.data.post.url +'</a></li>' );

                        var percentCompleted    = Math.ceil( ( storedtotalItems - totalItems ) * 100 / storedtotalItems );
                        var progressText        = percentCompleted != 100 ? percentCompleted + '%' : 'Done!';

                        progress
                        .find( '.progress-bar' )
                        .css( 'width', percentCompleted + '%' )
                        .text( progressText );
                        
                    }           
                }

                if ( response.success === false ) {
                    button.removeAttr('disabled').removeClass( 'd-none' );

                    var percentCompleted    = Math.ceil( ( storedtotalItems - totalItems ) * 100 / storedtotalItems );
                    var progressText        = percentCompleted != 100 ? percentCompleted + '%' : streamtube.done;

                    progress
                    .find( '.progress-bar' )
                    .css( 'width', percentCompleted + '%' )
                    .text( progressText );

                    list.removeClass( 'd-none' ).append( '<li class="border-bottom"><span class="text-danger">'+ response.data[0].message +'</span></li>' );

                    if( storedData.length > 0 ){
                        var entry = storedData.shift();
                        sessionStorage.setItem('bunny_items', JSON.stringify(storedData));
                        form.find( 'input[name=guid]' ).val( entry.guid );
                        form.trigger( 'submit' );
                    }                   
                } 
            }
        });
    }); 

    $( document.body ).on( 'delete_bunny_video', function( event, response, textStatus, jqXHR, element ){
        if( response.success == false ){
            return $.showToast( response.data, 'danger' );
        }else{
            element.closest( 'tr' ).remove();        }
    } );
    
    $( document.body ).on( 'delete_bunny_collection', function( event, response, textStatus, jqXHR, element ){
        if( response.success == false ){
            return $.showToast( response.data, 'danger' );
        }else{
            element.closest( 'tr' ).remove();        }
    } );    

})(jQuery);    