<?php
/**
 * The Collections template file
 * 
 * @link       https://1.envato.market/mgXE4y
 * @since      2.1
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists( 'StreamTube_Core_Bunny_Collections_List_Table' ) ){
    require_once dirname( dirname( __FILE__ ) ). '/class-streamtube-core-bunnycdn-collections-list-table.php';
}

$wp_list_table = new StreamTube_Core_Bunny_Collections_List_Table();

if( ! is_admin() ){
    streamtube_core_the_screen_options( $wp_list_table );
}

$wp_list_table->prepare_items();

streamtube_core_the_dashboard_head( esc_html__( 'Bunny collections', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();    
?>
<div class="wp-core-ui">
    <div id="wpbody-content">
        <form method="get">
            <?php
            $wp_list_table->search_box('Search', 'search');
            $wp_list_table->display();            
            ?>
        </form>
    </div>
</div>
<?php  

streamtube_core_the_dashboard_content_end();
