<?php
/**
 * The Bulk Import template file
 * 
 * @link       https://1.envato.market/mgXE4y
 * @since      2.1
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists( 'StreamTube_Core_Bunny_Videos_List_Table' ) ){
    require_once dirname( dirname( __FILE__ ) ). '/class-streamtube-core-bunnycdn-videos-list-table.php';
}

$wp_list_table = new StreamTube_Core_Bunny_Videos_List_Table();

if( ! is_admin() ){
    streamtube_core_the_screen_options( $wp_list_table );
}

$wp_list_table->prepare_items();

if( ! is_admin() ){
    streamtube_core_the_dashboard_head( esc_html__( 'Videos', 'streamtube-core' ) );

    streamtube_core_the_dashboard_content_start();    
    ?>
    <div class="wp-core-ui">
        <div id="wpbody-content">
    <?php
}

?>

<?php if( Streamtube_Core_BunnyCDN_Perms::import_videos() && current_user_can( get_post_type_object( 'video' )->cap->create_posts ) ): ?>
    <form id="import-bunny-all-videos">
        <?php printf(
            '<input type="hidden" name="page" value="%s" />',
            isset( $_REQUEST['page'] ) ? esc_attr( $_REQUEST['page'] ) : ''
        )?>
        <input type="hidden" name="paged" value="1" />
        <input type="hidden" name="per_page" value="10" />
        <input type="hidden" name="action" value="import_all_bunny_videos">
        <input type="hidden" name="guid" value="">
        <input type="hidden" name="confirm" value="on">
        <input type="hidden" name="confirm_msg" value="<?php esc_attr_e( 'Do you want to import all videos from Bunny library?', 'streamtube-core' )?>">
        <input type="hidden" name="_wpnonce" value="<?php echo esc_attr( wp_create_nonce( 'import_all_bunny_videos' ) )?>">
        <?php printf(
            '<input type="hidden" name="tab" value="%s" />',
            isset( $_REQUEST['tab'] ) ? esc_attr( $_REQUEST['tab'] ) : 'bulk-import'
        )?>    

        <p class="form-submit">
            <button type="submit" class="button button-primary">
                <?php esc_html_e( 'Mass Import All Videos', 'streamtube-core' );?>
            </button>        
        </p>

        <p class="alert alert-info p-2">
            <?php esc_html_e( 'Mass importing will also update the metadata of existing videos.', 'streamtube-core' );?>
        </p>

        <div class="progress-wrap bg-secondary rounded d-none" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
            <div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 0%; padding: 0 .5rem"></div>
        </div>

        <ol id="bunny-imported-list" class="video-imported-list bg-white p-4 px-5 mt-4 border d-none">

        </ol>

    </form>
<?php endif;?>

<form method="get">

    <?php printf(
        '<input type="hidden" name="page" value="%s" />',
        isset( $_REQUEST['page'] ) ? esc_attr( $_REQUEST['page'] ) : ''
    )?>

    <?php printf(
        '<input type="hidden" name="tab" value="%s" />',
        isset( $_REQUEST['tab'] ) ? esc_attr( $_REQUEST['tab'] ) : 'bulk-import'
    )?>

    <?php
        $wp_list_table->search_box('Search', 'search');
        $wp_list_table->display();
    ?>
</form>

<?php

if( ! is_admin() ){
    ?>
        </div>
    </div>
    <?php    
    streamtube_core_the_dashboard_content_end();
}