<?php
/**
 * Define the Big file uploads functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * Define the analytics functionality
 *
 * @since      1.0.8
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

/**
 * 
 */
class StreamTube_Core_Big_File_Uploads{

    /**
     *
     * Filter `wp_max_upload_size`
     * 
     * @param  integer $size
     * 
     */
    public function filter_max_upload_size( $size = 0 ){
        $tuxbfu_settings = get_option( 'tuxbfu_settings' );

        if( ! is_array( $tuxbfu_settings ) ){
            return $size;
        }

        $tuxbfu_max = (int)$tuxbfu_settings['limits']['all']['bytes'];

        if( ! is_user_logged_in() ){
            return $size;
        }

        if( is_array( $tuxbfu_settings ) ){
            if( $tuxbfu_settings['by_role'] ){

                $_roles = array();

                $roles = wp_get_current_user()->roles;

                foreach ( $tuxbfu_settings['limits'] as $role => $value ) {
                    $_roles[] = $role;
                }

                $intersect = array_intersect( $_roles , $roles );

                if( ! $intersect ){
                    return max( $size, $tuxbfu_max );
                }

                // Reset the array
                $intersect = array_values( $intersect );
                $bytes = array();

                foreach ( $tuxbfu_settings['limits'] as $role => $value ) {
                    if( in_array( $role , $intersect ) ){
                        $bytes[] = $value['bytes'];
                    }
                }

                if( $bytes ){
                    return max( $bytes );
                }else{
                    return max( $size, $tuxbfu_max );
                }
            }
        }
    }

}