<?php
/**
 *
 * Edit User Roles template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $wp, $wp_roles; 

$user_id    = isset( $_REQUEST['user_id'] ) ? absint( $_REQUEST['user_id'] ) : 0;

$userdata   = get_userdata( $user_id );

// Always check capability
if ( ! current_user_can( 'promote_users' ) || ! $userdata ) {
    return streamtube_core_the_notice(
        esc_html__( 'You do not have permission to promote this user.', 'streamtube-core' ),
        'danger'
    );    
}

streamtube_core_the_notice(
    sprintf(
        __( 'You are editing <strong>ID: #%s %s</strong> roles.', 'streamtube-core' ),
        $user_id,
        $userdata->user_login
    ),
    'info'
);

?>

<form class="form-ajax">
    <ul class="list-caps-checkboxes list-group list-group-numbered roles-list bg-white border">
        <?php

        foreach ( get_editable_roles() as $role_id => $value ) {

            printf(
                '<li class="bg-white border-bottom list-group-item role-item role-%s">',
                esc_attr( $role_id )
            );

            ?>
                <div class="mb-3 form-check">
            
                    <?php
                    printf(
                        '<input name="roles[]" value="%1$s" type="checkbox" class="form-check-input float-none" id="role-%1$s" %2$s %3$s />',
                        esc_attr( $role_id ),
                        user_can( $user_id, $role_id ) ? 'checked' : '',
                        $user_id === get_current_user_id() && user_can( $user_id, $role_id ) && $role_id === 'administrator' ? 'readonly disabled' : ''
                    );

                    printf( 
                        '<label class="form-check-label ms-2" for="role-%s">%s</label>', 
                        esc_attr( $role_id ),
                        translate_user_role($wp_roles->roles[ $role_id ]['name'])
                    );

                    ?>

                </div>
            </li>
            <?php
        }

        ?>
    </ul>

    <?php printf(
        '<input type="hidden" name="action" value="%s" />',
        'streamtube/add_user_roles'
    ); ?>

    <?php printf(
        '<input type="hidden" name="user_id" value="%s" />',
        esc_attr( $user_id )
    ); ?>    

    <?php printf(
        '<input type="hidden" name="_wpnonce" value="%s" />',
        esc_attr( wp_create_nonce( 'add_user_roles_' . $user_id ) )
    ); ?> 

    <?php printf(
        '<input type="hidden" name="redirect_uri" value="%s" />',
        esc_url( home_url( $wp->request ) )
    ); ?>        

    <div class="d-flex gap-3 mt-4">
    
        <button type="submit" class="btn btn-danger px-4">
            <span class="btn__icon icon-pencil"></span>
            <span class="btn__text"><?php esc_html_e( 'Update', 'streamtube-core' );?></span>
        </button>

        <?php printf(
            '<a class="text-body" href="%s">%s</a>',
            esc_url( home_url( $wp->request ) ),
            esc_html__( 'Back', 'streamtube-core' )
        )?>

    </div>
</form>