<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'bp_displayed_user_id', function () {
	return get_queried_object_id();
} );

add_filter( 'bp_displayed_user_fullname', function ($fullname) {
	return get_queried_object()->display_name;
} );

$heading = apply_filters( 'streamtube/core/user/profile/heading', esc_html__( 'Profile', 'streamtube-core' ) );
?>
<section class="profile-profile my-4">

	<?php printf(
		'<div class="%s">',
		esc_attr( join( ' ', streamtube_core_get_user_profile_container_classes() ) )
	) ?>

	<?php if ( $heading ) : ?>
		<div class="widget-title-wrap d-flex">
			<h2 class="widget-title no-after">
				<?php echo $heading; ?>
			</h2>
		</div>
	<?php endif; ?>

	<div class="user-bio p-4 shadow-sm bg-white rounded mb-4">

		<?php do_action( 'streamtube/core/user/profile/content' ); ?>

	</div>

	</div>

</section>