<?php
/**
 *
 * BuddyPress component template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $bp_component_object;

if( ! $bp_component_object ){
    return;
}

?>
<section class="section-profile profile-<?php echo esc_attr( $bp_component_object->component_id ); ?> my-4">
    <?php printf(
        '<div class="%s">',
        esc_attr( join( ' ', streamtube_core_get_user_profile_container_classes() )  )
    )?>

        <div class="widget-title-wrap d-flex">
            
            <h2 class="widget-title no-after">
                <?php echo $bp_component_object->name; ?>
            </h2>

        </div>

        <?php
        if( is_callable( $bp_component_object->screen_function ) ):
            call_user_func( $bp_component_object->screen_function );

            do_action( 'bp_template_content' );
        else:
            echo '<div class="alert alert-warning">';
            if( current_user_can( 'administrator' ) ){
                printf(
                    esc_html__( '%s callback was not found.', 'streamtube-core' ),
                    is_string( $bp_component_object->screen_function ) ? $bp_component_object->screen_function : json_encode( $bp_component_object->screen_function )
                );
            }else{
                esc_html_e( 'This page does not exist.', 'streamtube-core' );
            }
            echo '</div>';            
        endif;
        ?>

    </div>

</section>