<?php
/**
 *
 * Delete User template file
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp;

$user_id = isset( $_REQUEST['user_id'] ) ? absint( $_REQUEST['user_id'] ) : 0;

$userdata = get_userdata( $user_id );

// Always check capability
if ( ! current_user_can( 'delete_user', $user_id ) || ! $userdata ) {
	return streamtube_core_the_notice(
		esc_html__( 'You do not have permission to delete this user.', 'streamtube-core' ),
		'danger'
	);
}

?>

<form class="form-ajax">

	<?php streamtube_core_the_notice(
		sprintf(
			esc_html__( 'You have specified this user: ID: %s: %s', 'streamtube-core' ),
			$user_id,
			$userdata->user_login
		),
		'warning'
	); ?>

	<?php load_template( untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/reassign-user.php' ); ?>

	<?php printf(
		'<input type="hidden" name="action" value="%s" />',
		'streamtube/delete_user'
	); ?>

	<?php printf(
		'<input type="hidden" name="user_id" value="%s" />',
		esc_attr( $user_id )
	); ?>

	<?php printf(
		'<input type="hidden" name="_wpnonce" value="%s" />',
		esc_attr( wp_create_nonce( 'delete_user_' . $user_id ) )
	); ?>

	<?php printf(
		'<input type="hidden" name="redirect_uri" value="%s" />',
		esc_url( home_url( $wp->request ) )
	); ?>

	<div class="d-flex gap-3">

		<button type="submit" class="btn btn-danger px-3">
			<span class="btn__icon icon-trash-empty me-2"></span>
			<?php esc_html_e( 'Confirm Deletion', 'streamtube-core' ); ?>
		</button>

		<?php printf(
			'<a class="text-body" href="%s">%s</a>',
			esc_url( home_url( $wp->request ) ),
			esc_html__( 'Back', 'streamtube-core' )
		) ?>

	</div>
</form>