<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

define( 'STREAMTUBE_CORE_IS_DASHBOARD', true );

add_action( 'streamtube/core/user/dashboard/page_header/heading/after', function(){
    printf(
        '<button class="btn btn-sm btn-danger ajax-elm" data-action="%s" data-params="%s">%s</button>',
        'reset_metaboxes_order',
        esc_attr( streamtube_get_current_screen() ),
        esc_html__( 'Reset dashboard', 'streamtube-core' )
    );
} );

streamtube_core_the_dashboard_head( esc_html__( 'Dashboard', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

    /**
     *
     * Fires before user dashboard
     *
     * @since 1.0.8
     * 
     */
    do_action( 'streamtube/core/user/dashboard/dashboard/before' );

    $screen      = convert_to_screen( 'user_dashboard' );

    $columns     = apply_filters(
        'streamtube/core/user/dashboard/metabox/columns',
        $screen->get_columns() ? $screen->get_columns() : 3
    );
    $columns_css = '';

    if ( $columns ) {
        $columns_css = " columns-$columns";
    }
    ?>

    <div id="postbox-container-normal" class="postbox-container">
        <?php do_action( 'streamtube/core/user/dashboard/metabox', 'normal' ); ?>
    </div>

    <?php if( $columns ): ?>
        <div id="user-dashboard-widgets" class="dashboard-widgets metabox-holder<?php echo $columns_css; ?>">
            <?php 
                for ( $i=1;  $i <= $columns;  $i++) { 
                    ?><div id="postbox-container-<?php echo $i; ?>" class="postbox-container"><?php
                    do_action( 'streamtube/core/user/dashboard/metabox', 'column' . $i );
                    ?></div><?php
                }
            ?>
        </div>
    <?php endif;?>

    <div id="postbox-container-bottom" class="postbox-container">
        <?php do_action( 'streamtube/core/user/dashboard/metabox', 'bottom' ); ?>
    </div>

    <?php

    wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false );
    wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false );      

    /**
     *
     * Fires after user dashboard
     *
     * @since 1.0.8
     * 
     */
    do_action( 'streamtube/core/user/dashboard/dashboard/after' );

streamtube_core_the_dashboard_content_end();
