<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

$can = Streamtube_Core_Permission::can_manage_vast_tag();

streamtube_core_the_dashboard_head( esc_html__( 'Advertising', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();
?>
	<div class="bg-white p-4 shadow-sm">

		<?php if( ! $can ): ?>

			<p class="text-danger">
				<?php esc_html_e( 'You do not have permission to manage advertising', 'streamtube-core' );?>
			</p>

		<?php endif;?>

		<form class="form form-advertising form-ajax" method="post">
			<?php
			streamtube_core_the_field_control( array(
				'label'			=>	esc_html__( 'VAST Tag URL', 'streamtube-core' ),
				'name'			=>	'vast_tag_url',
				'value'			=>	streamtube_core()->get()->user->get_vast_tag_url( get_queried_object_id() ),
				'description'	=>	esc_html__( 'Automatically display VAST based ads in your videos.', 'streamtube-core' ),
				'data'			=>	array(
					'disabled'	=>	! $can ? 'disabled' : false
				)
			) );
			?>

			<div class="d-flex">
				<?php printf(
					'<button type="submit" class="btn btn-primary ms-auto" %s>',
					! $can ? 'disabled' : ''
				)?>
					<span class="icon-floppy"></span>
					<span class="button-label">
						<?php esc_html_e( 'Save', 'streamtube-core' ); ?>
					</span>
				</button>
			</div>

			<input type="hidden" name="action" value="update_advertising">	
		</form>
	</div>
<?php streamtube_core_the_dashboard_content_end();