<?php
/**
 *
 * The social profiles template file
 *
 * @since 2.2.1
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

streamtube_core_the_dashboard_head( esc_html__( 'Social Profiles', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

?>

    <div class="bg-white p-4 border-start border-right border-bottom border-end">
        <form class="form form-profile form-ajax" method="post">

            <div class="widget">
                <div class="widget-title-wrap d-flex">
                    <h2 class="widget-title no-after"><?php esc_html_e( 'Social Profiles', 'streamtube-core' );?></h2>              
                </div>
                <div class="widget-content">

                    <?php
                    /**
                     *
                     * Fires before fields
                     * 
                     */
                    do_action( 'streamtube/core/user/dashboard/settings/socials/before' );
                    ?>

                    <?php

                    foreach ( wp_get_user_contact_methods() as $social_id => $social_name ) {

                        streamtube_core_the_field_control( array(
                            'label'         =>  sprintf(
                                esc_html__( '%s URL', 'streamtube-core' ),
                                $social_name
                            ),
                            'name'          =>  'socials['. $social_id .']',
                            'value'         =>   streamtube_core()->get()->user->get_social_profiles( get_current_user_id(), $social_id )
                        ) );
                    }
                    ?>

                    <?php
                    /**
                     *
                     * Fires after fields
                     * 
                     */
                    do_action( 'streamtube/core/user/dashboard/settings/socials/after' );
                    ?>

                </div>

            </div>    

            <div class="d-flex">
                <button type="submit" class="btn btn-primary ms-auto">
                    <span class="icon-floppy"></span>
                    <span class="button-label">
                        <?php esc_html_e( 'Save Changes', 'streamtube-core' ); ?>
                    </span>
                </button>
            </div>

            <input type="hidden" name="action" value="update_social_profiles">

            <?php printf(
                '<input type="hidden" name="request_url" value="%s">',
                streamtube_core()->get()->rest_api['user']->get_rest_url( '/update-social-profiles' )
            );?>    
        </form>
    </div>

<?php streamtube_core_the_dashboard_content_end();