<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

if( ! function_exists( 'run_jwt_auth' ) ){
    streamtube_core_the_notice(
        esc_html__( 'The JWT Authentication plugin is not installed or activated!', 'streamtube-core' ),
        'warning'
    );
    return;
}

streamtube_core_the_dashboard_head( esc_html__( 'Access Token', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

?>
<form class="form-ajax">

    <?php
    streamtube_core_the_field_control( array(
        'label' =>  esc_html__( 'Enter your password', 'streamtube-core' ),
        'type'  =>  'password',
        'name'  =>  'password'
    ) );
    ?>

    <div class="token-wrap d-none">
        <?php
        streamtube_core_the_field_control( array(
            'label'         =>  esc_html__( 'Access Token', 'streamtube-core' ),
            'type'          =>  'textarea',
            'name'          =>  'token'
        ) );
        ?>

        <?php
        streamtube_core_the_notice(
            esc_html__( 'Be sure to save this in a safe location. You will not be able to retrieve it.', 'streamtube-core' ),
            'warning'
        );
        ?>

    </div>

    <?php printf(
        '<input type="hidden" name="username" value="%s">',
        esc_attr( wp_get_current_user()->user_login )
    );?>

    <input type="hidden" name="action" value="create_jwtauth_token">

    <?php printf(
        '<input type="hidden" name="request_url" value="%s">',
        esc_url( rest_url( '/jwt-auth/v1/token' ) )
    );?>

    <button class="btn btn-primary" type="submit">
        <span class="icon-code"></span>
        <span class="button-label"><?php esc_html_e( 'Create a token', 'streamtube-core' );?></span>
    </button>

</form>
<?php
streamtube_core_the_dashboard_content_end();    