<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

wp_enqueue_style( 'cropperjs' );
wp_enqueue_script( 'cropperjs' );

$user_id 	   	= get_current_user_id();
$field 			= 'avatar';

$image_url 		= streamtube_core()->get()->user->get_custom_avatar_url( $user_id );

streamtube_core_the_dashboard_head( esc_html__( 'Avatar', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

?>

    <div class="bg-white p-4 border-start border-right border-bottom border-end">

		<form class="form form-profile form-avatar form-user-photo form-ajax">

			<?php
			/**
			 *
			 * Fires before submit field
			 * 
			 */
			do_action( 'streamtube/core/user/dashboard/settings/avatar/form/before' );
			?>	

			<?php
			$opts = array(
				'viewMode'				=>	3,
				'dragMode'				=>	'move',
				'cropBoxMovable'		=>	false,
				'aspectRatio'			=>	'1/1',
				'rotatable'				=>	true,
				'minCropBoxWidth'		=>	250,
				'minCropBoxHeight'		=>	250
			);
			?>
			<div class="d-flex flex-column">
				<?php printf(
					'<div class="cropper-wrap border overflow-hidden position-relative" style="width: %spx; height: %spx">',
					esc_attr( $opts['minCropBoxWidth'] ),
					esc_attr( $opts['minCropBoxHeight'] )
				);?>

					<?php if( $image_url ) :
						printf(
							'<button type="button" class="btn-spinner btn btn-danger ajax-elm btn-sm p-1 position-absolute top-0 end-0" data-action="%s" data-params="%s">',
							'delete_user_photo',
							esc_attr( $field )
						);
						?>
							<span class="btn__icon icon-minus"></span>
						</button>
					<?php endif; ?>
					
					<?php printf(
						'<img data-option="%s" class="cropper-img" src="%s">',
						esc_attr( json_encode($opts) ),
						$image_url ? $image_url : ''
					);?>

				</div>
				<div class="form-submit mx-auto mt-4">

					<div class="d-md-flex d-block gap-3 align-items-start">
						<label class="btn btn-info text-white mb-2 d-block">
							<input type="file" name="file" class="cropper-input d-none" accept=".jpg,.jpeg,.png,.gif,.bmp,.tiff">
							<span class="icon-picture"></span>
							<span class="button-label">
								<?php esc_html_e( 'Browse image', 'streamtube-core' );?>
							</span>
						</label>

						<button type="submit" class="btn btn-primary mb-2 d-block">
							<span class="icon-floppy"></span>
							<span class="button-label">
								<?php esc_html_e( 'Save Changes', 'streamtube-core' ); ?>
							</span>
						</button>
					</div>

					<input type="hidden" name="image_data">
					<input type="hidden" name="image_base64">

					<input type="hidden" name="action" value="update_user_photo">

					<?php printf(
						'<input type="hidden" name="field" value="%s">',
						esc_attr( $field )
					);?>

					<?php printf(
						'<input type="hidden" name="request_url" value="%s">',
						streamtube_core()->get()->rest_api['user']->get_rest_url( '/upload-photo' )
					);?>					

				</div>
			</div>

			<?php
			/**
			 *
			 * Fires after submit field
			 * 
			 */
			do_action( 'streamtube/core/user/dashboard/settings/avatar/form/after' );
			?>
					
		</form>
			
	</div>
<?php streamtube_core_the_dashboard_content_end();