<?php
/**
 *
 * User Application Password template file
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $user_id;

if ( ! is_user_logged_in() ) {
	streamtube_core_the_notice(
		esc_html__( 'You must be logged in to view application passwords.', 'streamtube-core' ),
		'warning'
	);

	return;
}

$user_id      = get_current_user_id();
$profile_user = wp_get_current_user();

streamtube_core_the_dashboard_head( esc_html__( 'Application Passwords', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

if ( wp_is_application_passwords_available_for_user( $user_id ) || wp_is_application_passwords_supported() ) :

	wp_enqueue_script( 'wp-util' );
	wp_enqueue_script( 'application-passwords' );
	wp_enqueue_script( 'user-profile' );

	streamtube_core_the_notice(
		sprintf(
			esc_html__( 'Application passwords allow authentication via non-interactive systems, such as XML-RPC or the REST API, without providing your actual password. Application passwords can be easily revoked. They cannot be used for traditional logins to %s website.', 'streamtube-core' ),
			'<strong>' . untrailingslashit( home_url() ) . '</strong>'
		),
		'info'
	);

	if ( wp_is_application_passwords_available_for_user( $user_id ) ) :

		if ( ! wp_is_site_protected_by_basic_auth( 'front' ) ) :

			?>
			<div class="wp-core-ui">
				<div id="wpbody-content">
					<div class="application-passwords hide-if-no-js" id="application-passwords-section">
						<div class="create-application-password form-wrap">

							<?php
							streamtube_core_the_field_control( array(
								'label'       => esc_html__( 'New Application Password Name', 'streamtube-core' ),
								'required'    => true,
								'name'        => 'new_application_password_name',
								'id'          => 'new_application_password_name',
								'field_class' => 'form-control input-field w-100 input',
								'description' => esc_html__( 'Required to create an Application Password, but not to update the user.', 'streamtube-core' )
							) );

							/**
							 * Fires in the create Application Passwords form.
							 *
							 * @since 5.6.0
							 *
							 * @param WP_User $profile_user The current WP_User object.
							 */
							do_action( 'wp_create_application_password_form', $profile_user );

							printf(
								'<input type="hidden" name="user_id" id="user_id" value="%s">',
								esc_attr( $user_id )
							);
							?>

							<button type="submit" name="do_new_application_password" id="do_new_application_password"
								class="button button-primary btn btn-primary btn-sm">
								<?php esc_html_e( 'Add New Application Password', 'streamtube-core' ); ?>
							</button>
						</div>

						<div class="application-passwords-list-table-wrapper">
							<?php
							$application_passwords_list_table = _get_list_table(
								'WP_Application_Passwords_List_Table', array( 'screen' => 'application-passwords-user' )
							);
							$application_passwords_list_table->prepare_items();
							$application_passwords_list_table->display();
							?>
						</div>

						<?php if ( isset( $application_passwords_list_table ) ) : ?>
							<script type="text/html" id="tmpl-new-application-password">
													<div class="notice notice-success is-dismissible new-application-password-notice" role="alert">
														<p class="application-password-display">
															<label for="new-application-password-value">
																<?php
																printf(
																	/* translators: %s: Application name. */
																	__( 'Your new password for %s is:' ),
																	'<strong>{{ data.name }}</strong>'
																);
																?>
															</label>
															<input id="new-application-password-value" type="text" class="code" readonly="readonly" value="{{ data.password }}" />
															<button type="button" class="button copy-button" data-clipboard-text="{{ data.password }}"><?php _e( 'Copy' ); ?></button>
															<span class="success hidden" aria-hidden="true"><?php _e( 'Copied!' ); ?></span>
														</p>
														<p><?php _e( 'Be sure to save this in a safe location. You will not be able to retrieve it.' ); ?></p>
														<button type="button" class="notice-dismiss">
															<span class="screen-reader-text">
																<?php
																/* translators: Hidden accessibility text. */
																_e( 'Dismiss this notice.' );
																?>
															</span>
														</button>
													</div>
												</script>

							<script type="text/html" id="tmpl-application-password-row">
													<?php $application_passwords_list_table->print_js_template_row(); ?>
												</script>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<?php

		else :

			streamtube_core_the_notice(
				esc_html__( 'Website appears to use Basic Authentication, which is not currently compatible with Application Passwords.', 'streamtube-core' ),
				'warning'
			);

		endif;

	endif;

endif;

streamtube_core_the_dashboard_content_end();