<?php
/**
 *
 * Change Password template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $wp;

$user_id    = isset( $_REQUEST['user_id'] ) ? absint( $_REQUEST['user_id'] ) : 0;

$userdata   = get_userdata( $user_id );

// Always check capability
if ( ! current_user_can( 'edit_user', $user_id ) || ! $userdata ) {
    return streamtube_core_the_notice(
        esc_html__( 'You do not have permission to edit this user.', 'streamtube-core' ),
        'danger'
    );    
}

?>

<form class="form-ajax">

    <div class="bg-white p-4 border-start border-right border-bottom border-end">

        <?php
        streamtube_core_the_field_control( array(
            'type'              => 'text',
            'label'             => esc_html__( 'Password', 'streamtube-core' ),
            'name'              => 'pass1',
            'generate_passw'    =>  true
        ) );
        ?>
    
        <?php printf(
            '<input type="hidden" name="action" value="%s" />',
            'streamtube/change_user_password'
        ); ?>

        <?php printf(
            '<input type="hidden" name="user_id" value="%s" />',
            esc_attr( $user_id )
        ); ?>    

        <?php printf(
            '<input type="hidden" name="_wpnonce" value="%s" />',
            esc_attr( wp_create_nonce( 'change_user_password_' . $user_id ) )
        ); ?> 

        <?php printf(
            '<input type="hidden" name="redirect_uri" value="%s" />',
            esc_url( home_url( $wp->request ) )
        ); ?>       

        <div class="d-flex gap-3">
        
            <button type="submit" class="btn btn-danger px-3">
                <span class="btn__icon icon-pencil me-2"></span>
                <?php esc_html_e( 'Update', 'streamtube-core' );?>
            </button>

            <?php printf(
                '<a class="text-body" href="%s">%s</a>',
                esc_url( home_url( $wp->request ) ),
                esc_html__( 'Back', 'streamtube-core' )
            )?>

        </div>

    </div>    
</form>