<?php
/**
 * Storage Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

global $streamtube;

streamtube_core_the_dashboard_head( esc_html__( 'Storage Quota', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

$tabs       = $streamtube->get()->storage->get_setting_tabs();
$current    = isset( $_REQUEST['tab'] ) ? wp_unslash( $_REQUEST['tab'] ) : array_keys( $tabs )[0];
?>

<ul class="nav nav-tabs mb-4">
    <?php foreach ( $tabs as $key => $value ): ?>
        <li class="nav-item">
            <?php
            printf(
                '<a class="text-body nav-link%s" aria-current="page" href="%s">%s</a>',
                $current === $key ? ' active' : '',
                esc_url( add_query_arg(
                    array( 'tab' =>  $key ),
                    remove_query_arg( array_keys( $_REQUEST ), $_SERVER['REQUEST_URI'] )
                ) ),
                $value['title']
            );
            ?>
        </li>            
    <?php endforeach; ?>
</ul>

<div class="tab-content">
    <?php foreach ( $tabs as $key => $value ): ?>

        <?php 
        if( $current ===  $key ){
            if( isset( $value['callback'] ) && is_callable( $value['callback'] ) ){
                call_user_func( $value['callback'] );
            }
        }?>

    <?php endforeach; ?>
</div>

<?php

streamtube_core_the_dashboard_content_end();