<?php
/**
 * Roles Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

if( ! current_user_can( 'promote_users' ) ){
	streamtube_core_the_notice(
		esc_html__( 'You do not have permission to access this page.', 'streamtube-core' ),
		'danger'
	);
	return;	
}

global $wp_roles;

$role 	= isset( $_REQUEST['role'] ) 		? get_role( wp_unslash( $_REQUEST['role'] ) ) 	: '';
$nonce  = isset( $_REQUEST['_wpnonce'] ) 	? wp_unslash( $_REQUEST['_wpnonce'] ) 			: '';

if( $role && ! wp_verify_nonce( $nonce, 'edit-role-' . $role->name ) ){
	return streamtube_core_the_notice(
		esc_html__( 'Invalid nonce. Please refresh the page or try again later.', 'streamtube-core' ),
		'warning'
	);
}

wp_enqueue_script( 'streamtube-core-permission' );

if( $role ){
	add_action( 'streamtube/core/user/dashboard/page_header/heading/after', function(){
		printf(
			'<a href="%s" class="btn btn-sm btn-danger">',
			esc_url( remove_query_arg( array_keys( $_GET ), $_SERVER['REQUEST_URI'] ) ),
		);

			echo '<span class="btn__icon icon-plus"></span>';

			printf(
				'<span class="btn__text">%s</span>',
				esc_html__( 'Add new', 'streamtube-core' )
			);

		echo '</a>';
	});
}

streamtube_core_the_dashboard_head( esc_html__( 'Roles', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();
?>

<form method="post" class="form-ajax">
	<?php
		streamtube_core_the_field_control( array(
			'type'			=>	'text',
			'label'			=>	esc_html__( 'Role name', 'streamtube-core' ),
			'name'			=>	'role',
			'value'			=>	$role  ? $wp_roles->roles[ $role->name ]['name'] : '',
			'disabled'		=>	$role ? true : false,
			'required'		=>	true
		) );
	?>

	<div class="mb-4 d-flex align-items-center gap-4">
		<button type="submit" class="btn btn-primary btn-sm">
			<span class="btn__icon icon-floppy"></span>
			<span class="btn__text">
				<?php
				if( $role ){
					esc_html_e( 'Update', 'streamtube-core' );
				}else{
					esc_html_e( 'Add', 'streamtube-core' );
				}
				?>
			</span>
		</button>	

		<?php if( $role && ! in_array( $role->name , array( 'administrator', 'super-admin' ) ) ): ?>
			<?php printf(
				'<button type="button" class="btn btn-danger btn-sm ajax-elm" data-action="%s" data-params="%s" data-nonce="%s" data-confirm="%s">',
				'streamtube/core/delete_role',
				esc_attr( $role->name ),
				wp_create_nonce( 'delete-role-' . $role->name ),
                sprintf(
                    esc_attr__( 'Do you want to permanently delete the %s role?', 'streamtube-core' ),
                    translate_user_role( $wp_roles->roles[ $role->name ]['name'] )
                ),
			);?>
				<span class="btn__icon icon-trash"></span>
				<span class="btn__text">
					<?php esc_html_e( 'Delete', 'streamtube-core' );?>
				</span>
			</button>

			<?php printf(
				'<a href="%s" class="text-body fw-bold text-decoration-none">%s</a>',
				esc_url( remove_query_arg( array_keys( $_GET ), $_SERVER['REQUEST_URI'] ) ),
				esc_html__( 'Go back', 'streamtube-core' )
			);?>
		<?php endif;?>
	</div>

	<div class="row">

		<div class="col-12 col-lg-4">
			<?php streamtube_core_the_roles_list(); ?>
		</div>

		<div class="col-12 col-lg-8">
			<?php

			if( $role ){
				streamtube_core_the_field_control( array(
					'type'			=>	'text',
					'label'			=>	sprintf(
						esc_html__( 'Add new capability for %s', 'streamtube-core' ),
						$wp_roles->roles[ $role->name ]['name']
					),
					'name'			=>	'capability',
					'inline_button'	=>	sprintf(
						'<button type="button" class="%s" data-action="%s" data-params="%s" data-nonce="%s">%s</button>',
						'btn-spinner ajax-elm btn-add-capability btn btn-white position-absolute top-50 end-0 translate-middle-y shadow-none p-3',
						'streamtube/core/add_role_capability',
						esc_attr( $role->name ),
						esc_attr( wp_create_nonce( 'add-capability-' . $role->name ) ),
						'<span class="btn__icon icon-plus"></span>'
					)
				) );
			}	

			streamtube_core_the_field_control( array(
				'type'			=>	'search',
				'label'			=>	esc_html__( 'Search capabilities', 'streamtube-core' ),
				'name'			=>	'search-capabilities',
				'field_class'	=>	'search-list-item form-control input-field w-100'
			) );				
			?>

			<?php streamtube_the_showhide_nav_tabs(); ?>

			<?php streamtube_core_the_capability_checkboxes_list(); ?>
		</div>

	</div>

	<?php wp_nonce_field( 'add-role-' . get_current_user_id() );?>
	<input type="hidden" name="has_spinner" value="on">
	<input type="hidden" name="action" value="streamtube/core/add_role" />

	<?php if( $role ): ?>
		<?php printf( '<input type="hidden" name="edit_role" value="%s" />', $role->name ); ?>
	<?php endif;?>
</form>	

<?php
streamtube_core_the_dashboard_content_end();