<?php
/**
 * Max Upload File Size Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

global $wp_roles, $streamtube;

streamtube_core_the_dashboard_head( esc_html__( 'Maximum Upload File Size', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();
?>

    <div class="alert alert-info mb-4 p-4">
        <ul class="m-0">

            <li>
                <?php
                printf(
                    esc_html__( 'The maximum file size should not exceed %s. However, this limit can be increased if you use a streaming service or the %s plugin.', 'streamtube-core' ),
                    '<strong class="text-danger">'. size_format( streamtube_core_get_default_max_upload_size() ) .'</strong>',
                    '<a class="text-info" target="_blank" href="https://wordpress.org/plugins/tuxedo-big-file-uploads/">Big File Uploads</a>'
                );
                ?>
            </li>

            <li>
                <?php esc_html_e( 'Set to 0 for unlimited uploads or -1 to disable uploads.', 'streamtube-core' );?>
            </li>

            <li>
                <?php esc_html_e( 'In case a user has multiple roles:', 'streamtube-core' );?>

                <ul>
                    <li>
                        <?php esc_html_e( 'If any assigned role is set to -1, the user will not be allowed to upload files.', 'streamtube-core' );?>
                    </li>
                    <li>
                        <?php esc_html_e( 'If any assigned role is set to 0, the user will have no upload file size limit.', 'streamtube-core' );?>
                    </li>                    
                    <li>
                        <?php esc_html_e( 'Otherwise, the maximum upload file size defined by the roles will apply.', 'streamtube-core' );?>
                    </li>
                </ul>
            </li>
        </ul>
    </div>

    <form class="form-ajax">

        <?php 

        foreach ( streamtube_core_get_roles() as $role_id => $value ) :

            streamtube_core_the_field_control( array(
                'type'  =>  'text',
                'label' =>  translate_user_role( $wp_roles->roles[ $role_id ]['name'] ),
                'name'  =>  'roles['.$role_id.']',
                'value' =>  $streamtube->get()->storage->get_role_upload_size( $role_id ) / ( 1024*1024 ),
                'description'   =>  sprintf(
                    esc_html__( 'Maximum upload file size in %s for the %s role.', 'streamtube-core' ),
                    '<strong class="text-info">'. esc_html__( 'MB', 'streamtube-core' ) .'</strong>',
                    '<strong>'. esc_html( $wp_roles->roles[ $role_id ]['name'] ) .'</strong>'
                )
            ) );

        endforeach;
        ?>

        <?php wp_nonce_field( 'max_file_size' );?>

        <input type="hidden" name="action" value="streamtube/core/storage/update_roles_sizes">

        <p>
            <button type="submit" class="btn btn-primary px-3">
                <span class="btn__icon icon-pencil"></span>
                <span class="btn__text">
                    <?php esc_html_e( 'Update', 'streamtube-core' );?>
                </span>
            </button>
        </p>

    </form>

<?php

streamtube_core_the_dashboard_content_end();