<?php
/**
 * Posts List Table Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post_type, $wp_locale;

$wp_screen = 'edit-' . $post_type;

$wp_list_table = new StreamTube_Core_Posts_List_Table( array(
	'screen'    => $wp_screen,
	'post_type' => $post_type,
	'ajax'      => true
) );

if ( ! is_wp_error( $wp_list_table->has_errors() ) ) {
	$wp_list_table->enqueue_scripts();
}

streamtube_core_the_screen_options( $wp_list_table );

$post_id = isset( $_REQUEST['post_id'] ) ? absint( $_REQUEST['post_id'] ) : 0;
$nonce   = isset( $_REQUEST['_wpnonce'] ) ? wp_unslash( $_REQUEST['_wpnonce'] ) : '';
$action  = $wp_list_table->current_action();

$_nonce_action = $action . '-';

if ( $post_id && $nonce && $_nonce_action ) {
	if ( ! wp_verify_nonce( $nonce, $_nonce_action . $post_id ) ) {
		return streamtube_core_the_notice(
			esc_html__( 'The link you followed has expired.', 'streamtube-core' ),
			'danger'
		);
	}
}

$referer = wp_get_referer();
if ( ! $referer ) { // For POST requests.
	$referer = wp_unslash( $_SERVER['REQUEST_URI'] );
}
$referer = remove_query_arg( array( '_wp_http_referer', '_wpnonce', 'action', 'post_id', 'ids' ), $referer );

if ( $action ) {

	if ( isset( $_REQUEST['post'] ) ) {
		check_admin_referer( 'bulk-posts' );
	}

	$sendback = remove_query_arg( array( 'trashed', 'untrashed', 'deleted', 'locked', 'ids' ), wp_get_referer() );

	$post_ids = array();

	if ( isset( $_REQUEST['post'] ) && is_array( $_REQUEST['post'] ) ) {
		$post_ids = array_map( 'intval', $_REQUEST['post'] );
	}

	if ( $post_id ) {
		$post_ids[] = $post_id;
	}

	if ( 'delete_all' === $action ) {
		// Prepare for deletion of all posts with a specified post status (i.e. Empty Trash).
		$post_status = preg_replace( '/[^a-z0-9_-]+/i', '', $_REQUEST['post_status'] );
		// Validate the post status exists.
		if ( get_post_status_object( $post_status ) ) {
			/**
			 * @global wpdb $wpdb WordPress database abstraction object.
			 */
			global $wpdb;

			$post_ids = $wpdb->get_col(
				$wpdb->prepare( "SELECT ID FROM $wpdb->posts WHERE post_type=%s AND post_status = %s", $post_type, $post_status )
			);
		}
		$action = 'delete';
	}

	switch ( $action ) {

		case 'trash':

			$trashed = 0;

			foreach ( (array) $post_ids as $post_id ) {
				if ( current_user_can( 'delete_post', $post_id ) ) {
					if ( wp_trash_post( $post_id ) ) {
						$trashed++;
					}
				}
			}

			if ( $trashed ) {
				streamtube_core_the_notice(
					sprintf(
						_n( '%s item has been trashed.', '%s items have been trashed.', $trashed, 'streamtube-core' ),
						number_format_i18n( $trashed )
					),
					'success',
					true
				);
			}

			break;

		case 'untrash':

			$untrashed = 0;

			if ( isset( $_GET['doaction'] ) && ( 'undo' === $_GET['doaction'] ) ) {
				add_filter( 'wp_untrash_post_status', 'wp_untrash_post_set_previous_status', 10, 3 );
			}

			foreach ( (array) $post_ids as $post_id ) {

				if ( current_user_can( 'delete_post', $post_id ) ) {
					if ( wp_untrash_post( $post_id ) ) {
						++$untrashed;
					}
				}
			}

			remove_filter( 'wp_untrash_post_status', 'wp_untrash_post_set_previous_status', 10 );

			if ( $untrashed ) {
				streamtube_core_the_notice(
					sprintf(
						_n( '%s item has been restored.', '%s items have been restored.', $untrashed, 'streamtube-core' ),
						number_format_i18n( $untrashed )
					),
					'success',
					true
				);
			}

			break;

		case 'delete':
			$deleted = 0;
			foreach ( (array) $post_ids as $post_id ) {

				$post_del = get_post( $post_id );

				if ( current_user_can( 'delete_post', $post_id ) ) {
					if ( 'attachment' === $post_del->post_type ) {
						if ( wp_delete_attachment( $post_id ) ) {
							$deleted++;
						}
					} else {
						if ( wp_delete_post( $post_id, true ) ) {
							$deleted++;
						}
					}
				}
			}

			if ( $deleted ) {
				streamtube_core_the_notice(
					sprintf(
						_n( '%s item has been deleted.', '%s items have been deleted.', $deleted, 'streamtube-core' ),
						number_format_i18n( $deleted )
					),
					'success',
					true
				);
			}

			break;

		case 'edit':
			if ( isset( $_REQUEST['bulk_edit'] ) ) {
				$done = bulk_edit_posts( $_REQUEST );

				if ( is_array( $done ) ) {
					$count = count( $done['updated'] );
					streamtube_core_the_notice(
						sprintf(
							_n( '%s item has been updated.', '%s items have been updated.', $count, 'streamtube-core' ),
							number_format_i18n( $count )
						),
						'success',
						true
					);
				}
			}
			break;

		default:

			/**
			 * Fires when a custom bulk action should be handled.
			 *
			 * The redirect link should be modified with success or failure feedback
			 * from the action to be used to display feedback to the user.
			 *
			 * The dynamic portion of the hook name, `$screen`, refers to the current screen ID.
			 *
			 * @since 4.7.0
			 *
			 * @param string $sendback The redirect URL.
			 * @param string $doaction The action being taken.
			 * @param array  $items    The items to take the action on. Accepts an array of IDs of posts,
			 *                         comments, terms, links, plugins, attachments, or users.
			 */
			$sendback = apply_filters( "handle_bulk_actions-edit-{$post_type}", $sendback, $action, $post_ids );
			break;
	}
}

add_action( 'streamtube/core/user/dashboard/page_header/heading/after', function () {
	global $post_type;
	if ( current_user_can( get_post_type_object( $post_type )->cap->create_posts ) ) :
		if ( $post_type !== 'video' ) :
			printf( '<a class="btn btn-danger btn-sm text-white px-3" href="%s">', esc_url( streamtube_get_add_new_post_url() ) ); ?>
			<span class="btn__icon icon-plus"></span>
			<span class="btn__text">
				<?php esc_html_e( 'Add new', 'streamtube-core' ); ?>
			</span>
			</a>
			<?php
		else :
			?>
			<div class="dropdown">
				<a class="btn btn-danger btn-sm text-white px-3" data-bs-toggle="dropdown" data-bs-display="static">
					<span class="btn__icon icon-plus"></span>
					<span class="btn__text">
						<?php esc_html_e( 'Add new', 'streamtube-core' ); ?>
					</span>
				</a>
				<?php streamtube_core_load_template(
					'misc/upload-dropdown.php',
					false,
					array(
						'location' => false,
						'dropdown' => 'start'
					)
				); ?>
			</div>
			<?php
		endif;
	endif;
} );

streamtube_core_the_dashboard_head( get_post_type_object( $post_type )->labels->name );

streamtube_core_the_dashboard_content_start();

?>
<div class="wp-core-ui">
	<div id="wpbody-content">

		<?php

		$wp_list_table->prepare_items();
		$wp_list_table->views();
		?>

		<form id="posts-filter" method="get">
			<?php
			$wp_list_table->search_box(
				get_post_type_object( $post_type )->labels->search_items,
				$post_type
			);
			?>
			<input type="hidden" name="post_status" class="post_status_page"
				value="<?php echo ! empty( $_REQUEST['post_status'] ) ? esc_attr( $_REQUEST['post_status'] ) : 'all'; ?>" />

			<?php if ( ! empty( $_REQUEST['author'] ) ) { ?>
				<input type="hidden" name="author" value="<?php echo esc_attr( $_REQUEST['author'] ); ?>" />
			<?php } ?>

			<?php if ( ! empty( $_REQUEST['show_sticky'] ) ) { ?>
				<input type="hidden" name="show_sticky" value="1" />
			<?php } ?>

			<?php printf(
				'<input type="hidden" name="post_type" value="%s" />',
				esc_attr( $post_type )
			) ?>

			<?php $wp_list_table->display(); ?>
		</form>

		<?php
		if ( $wp_list_table->has_items() ) {
			add_thickbox();
			$wp_list_table->output_inline_edit();
		}
		?>

		<div id="ajax-response"></div>
		<div class="clear"></div>
	</div>
</div>
<?php

streamtube_core_the_dashboard_content_end();

if ( current_user_can( 'edit_others_posts' ) ) {
	streamtube_core_load_template( 'modal/approve-reject-message.php' );
}

if ( current_user_can( 'edit_posts' ) ) {
	streamtube_core_load_template( 'modal/delete-post.php' );
}

wp_reset_query();