<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

$args = wp_parse_args( $args, array(
    'location'  =>  'header',
    'dropdown'  =>  'end'
) );

$types = streamtube_core()->get()->user_dashboard->get_upload_types( $args['location'] );

if( ! $types ){
    return;
}

ob_start();

foreach( $types as $type => $v ):

    $v = wp_parse_args( $v, array(
        'url'   =>  '',
        'cap'   =>  ''
    ) );

    if( is_string( $v['cap'] ) && ! empty( $v['cap'] ) && ! current_user_can( $v['cap'] ) ){
        continue;
    }

    if( is_callable( $v['cap'] ) && call_user_func( $v['cap'] ) === false ){
        continue;
    }
    ?>

     <li class="type-<?php echo esc_attr( $type ); ?>">
        <?php

        if( $v['url'] ){
            printf(
                '<a href="%s"  class="dropdown-item d-flex align-items-center">',
                esc_url( $v['url'] ),
            );
        }else{
            printf(
                '<a href="#%1$s" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#modal-%1$s">',
                esc_attr( $type )
            );
        }

        ?>
            <?php printf(
                '<span class="menu-icon %s"></span>',
                sanitize_html_class( $v['icon'] )
            );?>
            <?php printf(
                '<span class="menu-text">%s</span>',
                $v['text']
            );?>
        </a>

    </li>

    <?php do_action( "streamtube/core/upload/{$type}/loaded", $type, $v );?>

<?php endforeach;

$output = ob_get_clean();

if( ! empty( $output ) ){
    printf(
        '<ul class="dropdown-menu dropdown-menu-%s animate slideIn">%s</ul>',
        esc_attr( $args['dropdown'] ),
        $output
    );
}