<?php
/**
 * The paid icon template file
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      2.2
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$args = wp_parse_args( $args, array(
	'icon'    => 'icon-lock',
	'label'   => esc_html__( 'Premium', 'streamtube-core' ),
	'html'    => '',
	'classes' => array_merge(
		explode( ' ', 'd-flex premium-badge membership-badge badge px-0 text-success' ),
		array( ! is_rtl() ? 'me-auto' : 'ms-auto' )
	),
	'service' => ''
) );

if ( ! $args['classes'] ) {
	$args['classes'] = array();
}

if ( is_string( $args['classes'] ) ) {
	$args['classes'] = explode( ' ', $args['classes'] );
}

if ( $args['service'] ) {
	$args['classes'][] = 'badge-' . $args['service'];
}

/**
 * Filters the arguments for the premium badge.
 */
$args = apply_filters( 'streamtube/core/premium_badge_args', $args );

printf(
	'<div class="%s">',
	esc_attr( join( ' ', $args['classes'] ) )
);

if ( $args['icon'] ) {
	printf(
		'<div class="icon %s"></div>',
		sanitize_html_class( $args['icon'] )
	);
}
?>

<?php
if ( $args['label'] ) {
	printf(
		'<div class="text">%s</div>',
		esc_html( $args['label'] )
	);
}

if ( $args['html'] ) {
	echo $args['html'];
}
?>

</div>