<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

global $post;

wp_enqueue_style( 'select2' );
wp_enqueue_script( 'select2' );

$options = array();

if( $post->post_parent ){
    $options = array(
        $post->post_parent => sprintf(
            '(#%s) %s',
            $post->post_parent,
            get_post( $post->post_parent )->post_title
        )
    );
}

printf( '<input type="hidden" name="post_parent" value="%s" />', '' );

streamtube_core_the_field_control( array(
    'label'         =>  esc_html( 'Parent', 'streamtube-core' ),
    'name'          =>  'post_parent',
    'id'            =>  'post_parent',
    'type'          =>  'select',
    'field_class'   =>  'form-control input-field w-100 post-parent',
    'options'       =>  $options,
    'current'       =>  $post->post_parent
) );

?>
<script type="text/javascript">
    jQuery( document ).ready(function() {
        jQuery( 'select.post-parent' ).select2({
            allowClear : true,
            placeholder : '<?php esc_js( esc_html__( 'Search parents', 'streamtube-core' ) ); ?>',
            minimumInputLength : 1,
            maximumInputLength: 100,
            ajax : {
                url : "<?php echo admin_url( 'admin-ajax.php' )?>",
                delay: 250,
                data: function (params) {
                    var query = {
                        s: params.term,
                        post_type : '<?php echo esc_js( $post->post_type )?>',
                        action: 'search_posts',
                        paged : params.page || 1,
                        responseType : 'select2',
                        _wpnonce : '<?php echo wp_create_nonce( 'search_posts_' . $post->post_type );?>'
                    }

                    return query;
                },
                processResults: function ( data, params ) {

                    params.page = params.page || 1;

                    return {
                        results: data.data.results,
                        pagination: data.data.pagination                     
                    };
                }
            }
        });
    });
</script>