<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

$googlesitekit 				= streamtube_core()->get()->googlesitekit;
$overview_metrics 			= $googlesitekit->analytics_rest_api->pre_get_overview_metrics();
$overview_video_metrics 	= $googlesitekit->analytics_rest_api->pre_get_overview_video_metrics();

$args = wp_parse_args( $args, array(
	'page_title'	=>	'<span class="icon-chart-area me-2"></span>' . esc_html__( 'Analytics', 'streamtube-core' ),
	'page_path'		=>	'',
	'start_date'	=>	isset( $_GET['start_date'] ) ? $_GET['start_date'] :  '7daysAgo',
	'end_date'		=>	isset( $_GET['end_date'] ) ? $_GET['end_date'] : 'yesterday'
) );

extract( $args );

$params = compact(
	'start_date', 'end_date', 'page_path'
);

wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false );
wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false );     
?>
<div class="page-head mb-3 d-flex align-items-center">

	<?php if( $page_title ): ?>
		<?php
		printf(
			'<h1 class="page-title h3">%s</h1>',
			$page_title
		);
		?>
	<?php endif;?>

	<?php include_once ( trailingslashit( plugin_dir_path( __FILE__ ) ) . '/start-date.php' ); ?>
</div>

<?php

streamtube_core_the_dashboard_content_start();

/**
 *
 * Fires before reports
 *
 *@since 1.0.8 
 * 
 */
do_action( 'streamtube/core/googlesitekit/reports/before', $params );
?>

<?php 

if( $googlesitekit->analytics->is_connected() ){
	do_action( 'streamtube/core/googlesitekit/metaboxes' );
}

/**
 *
 * Fires before reports
 *
 *@since 1.0.8 
 * 
 */
do_action( 'streamtube/core/googlesitekit/reports/after', $params );

streamtube_core_the_dashboard_content_end();
