<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

global $page_path;

$googlesitekit 				= streamtube_core()->get()->googlesitekit;
$overview_metrics 			= $googlesitekit->analytics_rest_api->pre_get_overview_metrics();
$overview_video_metrics 	= $googlesitekit->analytics_rest_api->pre_get_overview_video_metrics();
$start_dates    			= $googlesitekit->analytics->get_start_dates();
$start_date					= isset( $_GET['start_date'] ) ? $_GET['start_date'] :  '7daysAgo';
$end_date					= isset( $_GET['end_date'] ) ? $_GET['end_date'] : 'yesterday';

$post = streamtube_core()->get()->post->get_edit_post_object();

$params = compact(
	'start_date', 'end_date', 'page_path'
);

printf(
	'<div class="googlesitekit-reports" id="googlesitekit-reports" data-linechart-options="%s" data-overview-metrics="%s" data-overview-video-metrics="%s">',
	esc_attr( json_encode( streamtube_core_get_linechart_options() ) ),
	esc_attr( json_encode( $overview_metrics ) ),
	esc_attr( json_encode( $overview_video_metrics ) )
);?>
	<div class="analytics-section section-overview">

		<div class="analytics-section__header border-bottom mb-4 px-4 py-2 d-flex">
			<h2 class="section-title">
				<?php 


				if( $start_date == 'all' ){
					esc_html_e( 'Audience overview', 'streamtube-core' );
				}
				else{

					if( in_array( $start_date, array( 'today', 'yesterday' ) ) ){
						printf(
							esc_html__( 'Audience overview for %s', 'streamtube-core' ),
							$start_date
						);
					}

					elseif( array_key_exists( $start_date, $start_dates ) ){
						printf(
							esc_html__( 'Audience overview for the %s', 'streamtube-core' ),
							$start_dates[ $start_date ]
						);
					}
					else{
						$diff = (int)date_diff( date_create( $start_date ), date_create( $end_date ))->format("%R%a");
						printf(
							esc_html__( 'Audience overview for the last %s %s', 'streamtube-core' ),
							in_array( $diff, array( 0, 1 ) ) ? 1 : $diff,
							in_array( $diff, array( 0, 1 ) ) ? esc_html__( 'day', 'streamtube-core' ) : esc_html__( 'days', 'streamtube-core' )
						);					
					}
				}
				?>
			</h2>

		</div>

		<?php if( $overview_metrics ): ?>
			<?php printf(
				'<div class="analytics-section__content position-relative" id="analytics-overview" data-params="%s">',
				esc_attr( json_encode( $params ) )
			);?>
				<?php include ( trailingslashit( plugin_dir_path( __FILE__ ) ) . '/spinner.php' ); ?>
			</div>
		<?php endif;?>

		<?php if( defined( 'STREAMTUBE_CORE_IS_DASHBOARD' ) || ( $post && $post->post_type === 'video' )) : ?>

			<?php if( $overview_video_metrics ): ?>
				<?php printf(
					'<div class="analytics-section__content position-relative" id="analytics-overview-videos" data-params="%s">',
					esc_attr( json_encode( $params ) )
				);?>
					<?php include ( trailingslashit( plugin_dir_path( __FILE__ ) ) . '/spinner.php' ); ?>
				</div>	
			<?php endif;?>

		<?php endif;?>
	</div>
</div>