<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

/**
 * @since 2.1.7
 */
do_action( 'streamtube/core/form/embed_video/before' );
?>
<div id="embed-video-wrapper" class="upload-form__group">
	<?php
	/**
	 * @since 2.1.7
	 */
	do_action( 'streamtube/core/form/embed_video/container/before' );
	?>
	<?php streamtube_core_the_field_control( array(
		'label'			=>	esc_html__( 'Source', 'streamtube-core' ),
		'name'			=>	'source',
		'type'			=>	'textarea',
		'required'		=>	true
	) );
	?>

	<?php
	if( current_user_can( get_post_type_object( 'video' )->cap->publish_posts ) ){
		streamtube_core_the_field_control( array(
			'label'			=>	esc_html__( 'Status', 'streamtube-core' ),
			'name'			=>	'post_status',
			'id'			=>	'embed-post_status',
			'type'			=>	'select',
			'current'		=>	get_option( 'auto_publish' ) ? 'publish' : 'pending',
			'options'		=>	array(
				'publish'	=>	esc_html__( 'Publish', 'streamtube-core' ),
				'pending'	=>	esc_html__( 'Pending review', 'streamtube-core' )
			)
		) );
	}
	?>	
	<?php
	/**
	 * @since 2.1.7
	 */
	do_action( 'streamtube/core/form/embed_video/container/after' );
	?>	
</div>
<?php
/**
 * @since 2.1.7
 */
do_action( 'streamtube/core/form/embed_video/after' );
?>