<?php
/**
 *
 * Add Term form template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}
?>
<div id="ajax-response"></div>

<form id="addtag" method="post" action="#" class="validate">

    <?php
    streamtube_core_the_field_control( array(
        'label'         => esc_html__( 'Name', 'streamtube-core' ),
        'name'          => 'tag-name',
        'value'         => '',
        'description'   =>  esc_html__( 'The name is how it appears on your site.', 'streamtube-core' ),
        'field_class'   =>  'form-control input-field w-100',
        'wrap_class'    =>  'form-field'
    ) );
    ?>

    <?php
    streamtube_core_the_field_control( array(
        'label'         => esc_html__( 'Slug', 'streamtube-core' ),
        'name'          => 'slug',
        'value'         => '',
        'description'   =>  esc_html__( 'The slug is the URL-friendly version of the name. It is usually all lowercase and contains only letters, numbers, and hyphens.', 'streamtube-core' ),
        'field_class'   =>  'form-control input-field w-100',
        'wrap_class'    =>  'form-field'
    ) );
    ?>

    <?php if( is_taxonomy_hierarchical( $taxonomy ) ): ?>
        <div class="mb-4 field-group field-parent position-relative">
            <?php
                $dropdown_args = array(
                    'hide_empty'       => 0,
                    'hide_if_empty'    => false,
                    'taxonomy'         => $taxonomy,
                    'name'             => 'parent',
                    'orderby'          => 'name',
                    'hierarchical'     => true,
                    'show_option_none' => __( 'None' ),
                    'class'            =>  'form-control input-field w-100'
                );                            
                wp_dropdown_categories( 
                    apply_filters( 'taxonomy_parent_dropdown_args', $dropdown_args, $taxonomy, 'new' ) 
                );
            ?>
        </div>
    <?php endif;?>

    <?php
    streamtube_core_the_field_control( array(
        'label' => esc_html__( 'Description', 'streamtube-core' ),
        'name' => 'description',
        'value' => '',
        'type'  =>  'textarea',
        'description'   =>  esc_html__( 'The description is not prominent by default; however, some themes may show it.', 'streamtube-core' ),
        'field_class'   =>  'form-control input-field w-100',
        'wrap_class'    =>  'form-field'
    ) );
    ?>

    <?php
    if ( ! is_taxonomy_hierarchical( $taxonomy ) ) {
        /**
         * Fires after the Add Tag form fields for non-hierarchical taxonomies.
         *
         * @since 3.0.0
         *
         * @param string $taxonomy The taxonomy slug.
         */
        do_action( 'add_tag_form_fields', $taxonomy );
    }

    /**
     * Fires after the Add Term form fields.
     *
     * The dynamic portion of the hook name, `$taxonomy`, refers to the taxonomy slug.
     *
     * Possible hook names include:
     *
     *  - `category_add_form_fields`
     *  - `post_tag_add_form_fields`
     *
     * @since 3.0.0
     *
     * @param string $taxonomy The taxonomy slug.
     */
    do_action( "{$taxonomy}_add_form_fields", $taxonomy );
    ?>                        

    <input type="hidden" name="action" value="add-tag"> 

    <input type="hidden" name="is_frontend" value="on"> 

    <?php printf(
        '<input type="hidden" name="screen" value="edit-%s">',
        esc_attr( $taxonomy )
    ); ?>                        

    <?php printf(
        '<input type="hidden" name="taxonomy" value="%s">',
        esc_attr( $taxonomy )
    ); ?>

    <?php printf(
        '<input type="hidden" name="post_type" value="%s">',
        esc_attr( $post_type )
    )?>

    <?php wp_nonce_field( 'add-tag', '_wpnonce_add-tag' ); ?>

    <?php printf(
        '<input type="submit" name="submit" id="submit" class="btn btn-primary btn-sm" value="%s">',
        esc_attr__( 'Add New', 'streamtube-core' )
    );?>                    
</form>