(function($) {
    "use strict";

    var capListCheckboxes = $("ul.list-caps-checkboxes");

    $( document ).on('keyup', '.search-list-item', function(event) {
        var filter, text, found = 0;
        var me      = $(this);
        var filter  = me.val().toUpperCase(); // Convert the filter text to uppercase for consistency
        
        capListCheckboxes.find('li.capability-item').each(function(i) {
            var text = $(this).attr('data-capability' ).toUpperCase(); // Convert text to uppercase;
            if (text.indexOf(filter) > -1) {
                $(this).closest('li.capability-item').removeClass( 'd-none' );
                found++;
            } else {
                $(this).closest('li.capability-item').addClass( 'd-none' );
            }
        });
    });

    $( document ).on( 'click', 'a.show-all', function( event ){
        capListCheckboxes.find('li.capability-item').each(function(i) {
            $(this).removeClass( 'd-none' );
        });
    } );    

    $( document ).on( 'click', 'a.check-all', function( event ){
        capListCheckboxes.find('li.capability-item').each(function(i) {
            $(this).find('input.add-capability').prop('checked', true);
        });
    } );

    $( document ).on( 'click', 'a.uncheck-all', function( event ){
        capListCheckboxes.find('li.capability-item').each(function(i) {
            $(this).find('input.add-capability[data-nonce!="no-nonce"]').prop('checked', false);
        });
    } ); 

    $( document ).on( 'click', 'a.granted-all', function( event ){
        capListCheckboxes.find('li.capability-item').each(function(i) {

            var field = $(this).find( 'input.add-capability' );

            if( field.attr( 'data-granted' ) == 'checked' ){
                field.prop( 'checked', true );
                field.closest( 'li.capability-item' ).removeClass( 'd-none' );
            }else{
                field.prop( 'checked', false );
                field.closest( 'li.capability-item' ).addClass( 'd-none' );
            }
        });
    } );         

    $( document ).on( 'change', '.edit-capability', function(event){
        var me              = $(this);
        var capability      = me.val();
        var role            = me.attr( 'data-role' );
        var _wpnonce        = me.attr( 'data-nonce' );

        me.attr( 'disabled' );
        
        $.post( streamtube.ajaxUrl, {
            action          : 'streamtube/core/grant_role_capability',
            capability      : capability,
            role            : role,
            _wpnonce        : _wpnonce
        }, function( response ){
            if( response.success == false ){
                $.showToast( response.data, 'danger' );
            }else{
                if( response.data.data.action == 'removed' ){
                    me.next().removeClass( 'text-success fw-bold' ).addClass( 'text-danger' );
                }else{
                    me.next().addClass( 'text-success fw-bold' ).removeClass( 'text-danger' );
                }
            }

            me.removeAttr( 'disabled' );
        } );

    } );

    $( document.body ).on( 'streamtube/core/add_role', function( event, response, textStatus, jqXHR, formData, form ){
        if( response.success == false ){
            $.showToast( response.data, 'danger' );
        }else{
            form.find('input[name="role"]:not(:disabled)').val('').focus();

            if( response.data.output ){
                $( 'ul.roles-list' ).prepend( response.data.output );
            }

            $.showToast( response.data.message, 'success' );
        }
    } );

    /**
     *
     * Before deleting role
     * 
     */
    $( document.body ).on( 'streamtube/core/delete_role_before_send', function( event, element, formData  ){
        element.closest( '.list-group-item' ).addClass( 'bg-warning' ).removeClass( 'bg-white' );
    });

    $( document.body ).on( 'streamtube/core/delete_role', function( event, response, textStatus, jqXHR, element  ){
        if( response.success == false ){
            $.showToast( response.data, 'danger' );
            element.closest( '.list-group-item' ).removeClass( 'bg-warning' ).addClass( 'bg-white' );
        }else{
            var maybe_in_list = element.closest( '.list-group-item' );
            if( maybe_in_list.length != 0 ){
                maybe_in_list.remove();
            }else{
                window.location.href = window.location.href;
            }
        }
    });

    /**
     *
     * Hooking into 'streamtube/core/add_role_capability_before_send'
     * Append value from capability field to the formData
     * 
     */
    $( document.body ).on( 'streamtube/core/add_role_capability_before_send', function( event, element, formData  ){
        formData.append( 'capability', element.prev().val() );

        element.prev().attr( 'disabled', 'disabled' );
    });

    /**
     * 
     * `streamtube/core/add_role_capability` handler
     * 
     */
    $( document.body ).on( 'streamtube/core/add_role_capability', function( event, response, textStatus, jqXHR, element  ){
        if( response.success == false ){
            $.showToast( response.data, 'danger' );
        }else{
            capListCheckboxes.prepend( response.data.output );
        }

        element.prev().removeAttr( 'disabled' ).val('');
    });    

    /**
     *
     * Hooking into 'streamtube/core/delete_capability_before_send'
     * Change the list item background before send
     * 
     */
    $( document.body ).on( 'streamtube/core/delete_capability_before_send', function( event, element, formData  ){
        element.parent().addClass( 'bg-warning rounded' );
    });

    /**
     * 
     * `streamtube/core/add_role_capability` handler
     * 
     */
    $( document.body ).on( 'streamtube/core/delete_capability', function( event, response, textStatus, jqXHR, element  ){
        if( response.success == false ){
            element.parent().removeClass( 'bg-warning rounded' );
            $.showToast( response.data, 'danger' );
        }else{
            element.parent().remove();
            $.showToast( response.data.message, 'success' );
        }
    });     

})(jQuery);    