<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The Pre placehoder
 */
function streamtube_core_preplaceholder( $wrap_classes = array(), $row_classes = array(), $args = array() ) {

	$args = wp_parse_args( $args, array(
		'thumbnail_ratio' => '16x9',
		'author_avatar'   => false,
		'layout'          => 'grid',
		'slide_rows'      => 1
	) );

	extract( $args );

	?>
	<div class="preplacehoder overflow-hidden">

		<?php printf(
			'<div class="%s">',
			esc_attr( join( ' ', $wrap_classes ) )
		); ?>
		<div class="<?php echo join( ' ', $row_classes ); ?>">

			<?php for ( $i = 0; $i < $col_xxl * absint( $slide_rows ); $i++ ) : ?>

				<?php printf(
					'<div class="post-item %s mb-%s">',
					$layout != 'grid' ? 'p-0' : '',
					esc_attr( $margin_bottom )
				); ?>
				<div class="ph-item p-0 m-0">

					<?php if ( $layout == 'grid' ) : ?>

						<div class="ph-col-12 p-0 m-0">
							<div
								class="post-thumbnail ratio ratio-<?php echo esc_attr( $thumbnail_ratio ); ?> rounded overflow-hidden">
								<div class="ph-picture"></div>
							</div>
							<div class="ph-row mb-3">
							</div>
						</div>

						<?php if ( $author_avatar ) : ?>
							<div class="ph-col-2">
								<div class="ph-avatar"></div>
							</div>
						<?php endif; ?>

						<div>
							<div class="ph-row">
								<div class="ph-col-12"></div>
								<div class="ph-col-2"></div>
							</div>
						</div>
					<?php else : ?>
						<div class="ph-col-2 p-0">
							<div
								class="post-thumbnail ratio ratio-<?php echo esc_attr( $thumbnail_ratio ); ?> rounded overflow-hidden">
								<div class="ph-picture"></div>
							</div>
						</div>

						<div>
							<div class="ph-row">
								<div class="ph-col-10 big"></div>
								<div class="ph-col-2 empty big"></div>
								<div class="ph-col-4"></div>
								<div class="ph-col-8 empty"></div>
							</div>
						</div>
					<?php endif; ?>

				</div><!--.ph-item-->

			</div><!--.post-item-->

		<?php endfor; ?>
	</div><!--.end row-->
	</div><!--.end wrapper-->
	</div><!--end placehoder-->
	<?php
}

/**
 *
 * Generate the notice
 * 
 * @param  string|WP_Error $cont
 * @param  string $type
 * 
 * Output the notice
 */
function streamtube_core_the_notice( $content = '', $type = 'info', $dismiss = false ) {
	$messages = array();

	// Check if $content is a string
	if ( is_string( $content ) && ! empty( $content ) ) {
		$messages[] = $content;
	}

	// Check if $content is a WP_Error instance and retrieve error messages if available
	if ( $content instanceof WP_Error ) {
		$error_messages = $content->get_error_messages();
		if ( ! empty( $error_messages ) ) {
			$messages = array_merge( $messages, $error_messages );
		}
	}

	// Display messages if any exist
	if ( $messages ) {
		printf(
			'<div class="mb-4 p-2 px-3 alert alert-%s %s">%s %s</div>',
			esc_attr( $type ),
			$dismiss ? 'alert-dismissible fade show' : '',
			wp_kses_post( '<p class="m-0">' . join( '</p><p class="m-0">', $messages ) . '</p>' ),
			$dismiss ? '<button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>' : ''
		);
	}
}

/**
 *
 * Get post status text
 * 
 * @param  WP_Post $post
 * @return string
 * 
 */
function streamtube_get_the_post_status_alert( $post = null ) {

	if ( ! $post ) {
		return;
	}

	$post_type_label = get_post_type_object( $post->post_type )->labels->singular_name;

	ob_start();

	$message = sprintf(
		esc_html__( 'This %s is %s.', 'streamtube-core' ),
		strtolower( $post_type_label ),
		strtolower( streamtube_core_get_post_visibility( $post ) )
	);

	switch ($post->post_status) {
		case 'future':
			?>
			<p class="alert alert-post-status alert-scheduled alert-info p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		case 'pending':
			?>
			<p class="alert alert-post-status alert-warning p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		case 'draft':
			?>
			<p class="alert alert-post-status alert-warning p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		case 'private':
			?>
			<p class="alert alert-post-status alert-info p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		case 'unlist':
			?>
			<p class="alert alert-post-status alert-info p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		case 'reject':
			?>
			<p class="alert alert-post-status alert-danger p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		case 'trash':
			?>
			<p class="alert alert-post-status alert-danger p-2 px-3">
				<?php echo $message; ?>
			</p>
			<?php
			break;

		default:
			/**
			 *
			 * 
			 * 
			 */
			do_action( 'streamtube/core/post/edit/post_status_info', $post );
			break;
	}

	return ob_get_clean();
}

/**
 *
 * Display the dashboard page header
 * 
 */
function streamtube_core_the_dashboard_head( $heading = '' ) {

	$screen = get_query_var( 'dashboard' );

	if ( ! $screen ) {
		$screen = 'dashboard';
	}

	/**
	 *
	 * Fires before page header
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/page_header/before' );

	/**
	 *
	 * Fires before page header
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_header/before' );
	?>

	<div class="page-head mb-3 d-flex gap-3 align-items-center border-bottom">
		<?php

		/**
		 *
		 * Fires before heading
		 * 
		 */
		do_action( 'streamtube/core/user/dashboard/page_header/heading/before' );

		/**
		 *
		 * Fires before heading
		 * 
		 */
		do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_header/heading/before' );
		?>
		<h1 class="page-title text-body h2">
			<?php

			/**
			 *
			 * Fires before heading
			 * 
			 */
			do_action( 'streamtube/core/user/dashboard/page_header/heading/inside/before' );

			/**
			 *
			 * Fires before heading
			 * 
			 */
			do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_header/heading/inside/before' );

			echo apply_filters(
				'streamtube/core/dashboard/page_header/heading',
				$heading
			);

			/**
			 *
			 * Fires after heading
			 * 
			 */
			do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_header/heading/inside/after' );

			/**
			 *
			 * Fires after heading
			 * 
			 */
			do_action( 'streamtube/core/user/dashboard/page_header/heading/inside/after' );
			?>
		</h1>
		<?php
		/**
		 *
		 * Fires before heading
		 * 
		 */
		do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_header/heading/after' );

		/**
		 *
		 * Fires before heading
		 * 
		 */
		do_action( 'streamtube/core/user/dashboard/page_header/heading/after' );
		?>
	</div>

	<?php

	/**
	 *
	 * Fires after page header
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_header/after' );

	/**
	 *
	 * Fires after page header
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/page_header/after' );
}

/**
 *
 * Begin of dashboard content
 * 
 */
function streamtube_core_the_dashboard_content_start() {
	$screen = get_query_var( 'dashboard' );
	/**
	 *
	 * Fires before page content
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/page_content/before' );
	/**
	 *
	 * Fires before page content
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/' . untrailingslashit( $screen ) . '/page_content/before' );

	echo '<div class="page-content">';
}

/**
 *
 * End of dashboard content
 * 
 */
function streamtube_core_the_dashboard_content_end() {

	$screen = get_query_var( 'dashboard' );

	echo '<div class="clear"></div></div>';

	/**
	 *
	 * Fires after page content
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/' . $screen . '/page_content/after' );

	/**
	 *
	 * Fires after page content
	 * 
	 */
	do_action( 'streamtube/core/user/dashboard/page_content/after' );
}

/**
 *
 * The show/hide nav bar
 * 
 */
function streamtube_the_showhide_nav_tabs() {
	$tabs = array(
		'show-all'    => esc_html__( 'Show all', 'streamtube-core' ),
		'check-all'   => esc_html__( 'Check all', 'streamtube-core' ),
		'uncheck-all' => esc_html__( 'Uncheck all', 'streamtube-core' ),
		'granted-all' => esc_html__( 'Granted Only', 'streamtube-core' ),
	);

	echo '<ul class="nav nav-tabs">';
	foreach ( $tabs as $class => $label ) {
		printf(
			'<li class="nav-item mb-0"><a data-bs-toggle="tab" class="%1$s nav-link shadow-none text-body %2$s" href="#">%3$s</a></li>',
			esc_attr( $class ),
			$class === array_keys( $tabs )[0] ? 'active' : '',
			esc_html( $label )
		);
	}
	echo '</ul>';
}

/**
 *
 * Output the roles dropdown
 * 
 * @param  string $selected
 * 
 */
function streamtube_core_the_roles_dropdown( $selected = '' ) {

	global $wp_roles;

	if ( ! $selected ) {
		$selected = isset( $_REQUEST['role'] ) ? wp_unslash( $_REQUEST['role'] ) : '';
	}

	$options = array(
		'all' => esc_html__( 'All', 'streamtube-core' )
	);

	foreach ( get_editable_roles() as $role_id => $value ) {
		$options[ $role_id ] = translate_user_role( $wp_roles->roles[ $role_id ]['name'] );
	}

	streamtube_core_the_field_control( array(
		'type'    => 'select',
		'label'   => esc_html__( 'Roles', 'streamtube-core' ),
		'name'    => 'role',
		'options' => $options,
		'current' => $selected
	) );
}

function streamtube_core_the_role_list_item( $role_id, $current = '' ) {

	if ( ! $current ) {
		$current = isset( $_REQUEST['role'] ) ? wp_unslash( $_REQUEST['role'] ) : '';
	}

	global $wp_roles;

	$user_count = count_users();

	$url = wp_doing_ajax() ? wp_get_referer() : '';

	$edit_url = wp_nonce_url(
		add_query_arg(
			array(
				'role' => $role_id
			),
			$url
		),
		'edit-role-' . $role_id
	);

	$li = '';

	$li .= sprintf(
		'<li class="role role-%1$s %2$s mb-0 p-3 border-0 border-bottom list-group-item d-flex justify-content-between align-items-start">',
		esc_attr( $role_id ),
		$current == $role_id ? 'bg-light' : 'bg-white'
	);

	$li .= '<div class="ms-2 me-auto">';

	$li .= sprintf(
		'<div class="fw-bold"><a class="shadow-none fw-bold text-decoration-none %s" href="%s">%s (%s)</a></div>',
		$current == $role_id ? 'text-info' : 'text-body',
		esc_attr( $edit_url ),
		translate_user_role( $wp_roles->roles[ $role_id ]['name'] ),
		esc_attr( $role_id )
	);

	if ( StreamTube_Core_Role::can_promote_users() ) {
		$li .= '<div class="d-flex mt-2 gap-3">';

		if ( ! StreamTube_Core_Role::is_admin_role( $role_id ) ) {
			$li .= sprintf(
				'<a class="ajax-elm text-danger text-decoration-none small" href="#" data-action="%s" data-params="%s" data-nonce="%s" data-confirm="%s"><span class="icon-trash"></span> %s</a>',
				'streamtube/core/delete_role',
				esc_attr( $role_id ),
				wp_create_nonce( 'delete-role-' . $role_id ),
				sprintf(
					esc_attr__( 'Do you want to permanently delete the %s (%s) role?', 'streamtube-core' ),
					esc_html( translate_user_role( $wp_roles->roles[ $role_id ]['name'] ) ),
					esc_html( $role_id )
				),
				esc_html__( 'delete', 'streamtube-core' )
			);
		}

		$li .= sprintf(
			'<a class="text-secondary small text-decoration-none" href="%s"><span class="icon-pencil"></span> %s</a>',
			esc_attr( $edit_url ),
			esc_html__( 'edit', 'streamtube-core' )
		);
		$li .= '</div>';
	}

	$li .= '</div>';

	if ( isset( $user_count['avail_roles'][ $role_id ] ) ) {
		$li .= sprintf(
			'<span class="badge bg-info rounded-pill">%s</span>',
			sprintf(
				_n(
					'%s member', '%s members',
					$user_count['avail_roles'][ $role_id ], 'streamtube-core' ),
				number_format_i18n( $user_count['avail_roles'][ $role_id ]
				)
			)
		);
	}

	$li .= '</li>';

	return $li;
}

/**
 *
 * Output the roles dropdown
 * 
 * @param  string $selected
 * 
 */
function streamtube_core_the_roles_list( $current = '' ) {

	$user_count = count_users();

	$list = '';

	foreach ( get_editable_roles() as $role_id => $value ) {
		$list .= streamtube_core_the_role_list_item( $role_id, $current );
	}

	if ( $list ) {
		printf(
			'<ul class="list-group list-group-numbered roles-list bg-white border">%s</ul>',
			$list
		);
	}
}

/**
 *
 * Output The modules dropdown
 * 
 */
function streamtube_core_the_modules_dropdown( $selected = '' ) {
	global $streamtube_modules;

	if ( ! $selected ) {
		$selected = isset( $_REQUEST['module'] ) ? wp_unslash( $_REQUEST['module'] ) : '';
	}

	$options = array();

	foreach ( $streamtube_modules as $module => $value ) {
		$options[ $module ] = $value['name'];
	}

	streamtube_core_the_field_control( array(
		'type'    => 'select',
		'label'   => esc_html__( 'Modules', 'streamtube-core' ),
		'name'    => 'module',
		'options' => $options,
		'current' => $selected
	) );
}

/**
 *
 * Output the Module checkboxes list
 * 
 */
function streamtube_core_the_module_capability_checkboxes_list( $module_id = '', $role = '' ) {

	$checkboxes  = '';
	$role_object = false;

	global $streamtube_modules;

	if ( ! $module_id ) {
		$module_id = isset( $_REQUEST['module'] ) ? wp_unslash( $_REQUEST['module'] ) : '';
	}

	if ( ! $role ) {
		$role = isset( $_REQUEST['role'] ) ? wp_unslash( $_REQUEST['role'] ) : '';
	}

	if ( $role ) {
		$role_object = get_role( $role );
	}

	if ( is_string( $module_id ) && array_key_exists( $module_id, $streamtube_modules ) ) {

		ob_start();

		$module       = $streamtube_modules[ $module_id ];
		$capabilities = (array) $module['capabilities'];
		$caution      = sprintf(
			'<span class="text-danger fw-bold ms-1">(%s)</span>',
			esc_html__( 'caution', 'streamtube-core' )
		);

		for ( $i = 0; $i < count( $capabilities ); $i++ ) {

			$has_cap = $role_object && $role_object->has_cap( $capabilities[ $i ] ) ? true : false;

			printf(
				'<li class="bg-white border-bottom list-group-item capability capability-%s">',
				esc_attr( $capabilities[ $i ] )
			);

			echo '<div class="mb-3 form-check">';

			printf(
				'<input %1$s class="edit-capability form-check-input float-none" type="checkbox" name="capability" value="%2$s" data-role="%3$s" data-nonce="%4$s" id="capability-%3$s-%2$s" />',
				$has_cap ? 'checked' : '',
				esc_attr( $capabilities[ $i ] ),
				esc_attr( $role ),
				esc_attr( wp_create_nonce( 'edit-cap-' . $capabilities[ $i ] ) )
			);

			printf(
				'<label class="form-check-label ms-2 %1$s" for="capability-%3$s-%2$s">%2$s %4$s</label>',
				$has_cap ? 'text-success fw-bold' : 'text-danger',
				$capabilities[ $i ],
				esc_attr( $role ),
				preg_match( '/(edit_other|delete_other|read_private)/', $capabilities[ $i ] ) ? $caution : ''
			);

			echo '</div>';

			echo '</li>';

		}

		$checkboxes = ob_get_clean();
	}

	if ( $checkboxes ) {
		printf(
			'<ul class="list-caps-checkboxes list-group list-group-numbered m-0 p-0 border checkboxes-rendered">%s</ul>',
			$checkboxes
		);
	}
}

/**
 *
 * The Capability list item
 * 
 */
function streamtube_core_the_capability_list_item( $capability = '', $role = '' ) {

	$can_be_ungranted = true;

	$li      = '';
	$has_cap = $can_be_deleted = false;

	if ( $role ) {
		$role = get_role( $role );

		if ( $role ) {
			$has_cap = $role->has_cap( $capability );
		}

		$can_be_ungranted = StreamTube_Core_Role::can_ungrant_capability( $role->name, $capability );
	}

	// Check if capability can be deleted
	$can_be_deleted = StreamTube_Core_Role::can_delete_capability( $capability );

	$li .= sprintf(
		'<li class="bg-white border-bottom list-group-item capability-item capability-%1$s" data-capability="%1$s">',
		esc_attr( $capability )
	);

	$li .= '<div class="mb-3 form-check">';

	$li .= sprintf(
		'<input %5$s data-granted="%1$s" %1$s class="add-capability form-check-input float-none" type="checkbox" name="capabilities[]" value="%2$s" data-role="%3$s" data-nonce="%4$s" id="capability-%2$s" />',
		$has_cap ? 'checked' : '',
		esc_attr( $capability ),
		$role ? esc_attr( $role->name ) : '',
		$can_be_ungranted ? esc_attr( wp_create_nonce( 'edit-cap-' . $capability ) ) : 'no-nonce',
		! $can_be_ungranted ? 'readonly disabled="disabled"' : ''
	);

	$li .= sprintf(
		'<label class="form-check-label ms-2 %1$s" for="capability-%2$s">%2$s</label>',
		$has_cap ? 'text-success fw-bold' : 'text-muted',
		esc_attr( $capability )
	);

	$li .= '</div>';

	if ( $can_be_deleted ) {
		$li .= sprintf(
			'<a class="ajax-elm text-danger text-decoration-none small" href="#" data-action="%s" data-params="%s" data-nonce="%s" data-confirm="%s"><span class="icon-trash"></span> %s</a>',
			'streamtube/core/delete_capability',
			esc_attr( $capability ),
			wp_create_nonce( 'delete-capability-' . $capability ),
			esc_attr__( 'Delete Capability - Warning! Be careful - deleting critical capability could crash some plugin or other custom code.\n\nFeel free to delete this capability if it is newly created, has not been assigned to any roles or users, or has not been used for any purpose.', 'streamtube-core' ),
			esc_html__( 'delete', 'streamtube-core' )
		);
	}

	$li .= '</li>';

	return $li;
}

/**
 *
 * Output the Capability checkboxes list
 * 
 */
function streamtube_core_the_capability_checkboxes_list( $role = '' ) {

	$list = '';

	if ( ! $role ) {
		$role = isset( $_REQUEST['role'] ) ? wp_unslash( $_REQUEST['role'] ) : '';
	}

	$capabilities = StreamTube_Core_Role::get_all_capabilities();

	for ( $i = 0; $i < count( $capabilities ); $i++ ) {

		if ( ! isset( $capabilities[ $i ] ) || trim( $capabilities[ $i ] ) == '' ) {
			continue;
		}

		$list .= streamtube_core_the_capability_list_item( $capabilities[ $i ], $role );
	}

	if ( $list ) {
		printf(
			'<ul class="list-caps-checkboxes list-group list-group-numbered m-0 p-0 border">%s</ul>',
			$list
		);
	}
}

/**
 *
 * Generate the Screen Options
 * 
 * @param  $wp_list_table
 * 
 */
function streamtube_core_the_screen_options( $wp_list_table = null, $screen_id = '' ) {

	global $post_type_screen, $taxonomy;

	$current_screen = '';
	$columns        = $hiddens = array();
	$post_type = '';
	$user_id   = get_current_user_id();

	if ( $wp_list_table ) {
		$columns = get_column_headers( $wp_list_table->screen );

		$screen_id = $wp_list_table->screen->id;

		$post_type = property_exists( $wp_list_table->screen, 'post_type' ) && $wp_list_table->screen->post_type
			? $wp_list_table->screen->post_type
			: $screen_id;

	}

	if ( $post_type_screen ) {
		$current_screen = $post_type_screen;
	}

	if ( $taxonomy ) {
		$current_screen = $taxonomy;
	}

	$screen_id = $screen_id ? $screen_id : $current_screen;

	if ( $columns ) :

		if ( isset( $columns['cb'] ) ) {
			unset( $columns['cb'] );
		}

		if ( isset( $_REQUEST['screen_options'] ) && wp_verify_nonce( $_REQUEST['screen_options'], $screen_id ) ) {

			// Sanitize and validate the submitted columns
			$submitted_columns = isset( $_REQUEST['columns'] ) ? array_map( 'sanitize_text_field', $_REQUEST['columns'] ) : [];

			// Calculate the hidden columns by finding the difference
			$hiddens = array_values( array_diff( array_keys( $columns ), $submitted_columns ) );

			// Save the hidden columns as user meta
			update_user_option( $user_id, 'manage' . $screen_id . 'columnshidden', $hiddens );

			if ( isset( $_REQUEST['per_page'] ) ) {
				update_user_option( $user_id, 'edit_' . $screen_id . '_per_page', absint( $_REQUEST['per_page'] ) );
			}
		}

		if ( $wp_list_table ) {
			$hiddens = (array) get_user_option( 'manage' . $screen_id . 'columnshidden', $user_id );

			$per_page = (int) get_user_option( 'edit_' . $screen_id . '_per_page', $user_id );
		}

		echo '<div id="screen-options" class="collapse"><form method="post" class="bg-white p-4 border">';

		foreach ( $columns as $key => $value ) :
			if ( $key === 'cb' ) {
				continue;
			}
			?>
			<span class="mb-4 me-4 d-inline-block form-check">

				<?php printf(
					'<input type="checkbox" class="form-check-input hide-column-tog" name="columns[]" value="%1$s" id="col-%1$s" %2$s>',
					esc_attr( $key ),
					! in_array( $key, $hiddens ) ? 'checked' : ''
				); ?>

				<?php printf(
					'<label class="form-check-label" for="col-%s">%s</label>',
					esc_attr( $key ),
					wp_strip_all_tags( $value )
				); ?>
			</span>
			<?php
		endforeach;

		if ( $wp_list_table ) :
			?>
			<fieldset class="mb-4 d-flex align-items-start gap-3">
				<label>
					<?php esc_html_e( 'Number of items per page', 'streamtube-core' ); ?>
				</label>
				<?php printf(
					'<input class="w-auto" class="form-control-sm" type="number" name="per_page" value="%s" id="per-page">',
					$per_page !== 0 ? absint( $per_page ) : 20
				); ?>
			</fieldset>
			<?php
		endif;

		printf(
			'<input type="hidden" name="screen_options" value="%s">',
			esc_attr( wp_create_nonce( $screen_id ) )
		);

		printf(
			'<p class="border-top pt-4"><button type="submit" class="btn btn-sm btn-primary">%s</button></p>',
			esc_html__( 'Apply', 'streamtube-core' )
		);

		echo '</form></div>';

		printf(
			'<div id="screen-options-toggle" class="float-end bg-white p-2 px-4 border"><a class="text-decoration-none text-body small" href="#" data-bs-toggle="collapse" data-bs-target="#screen-options">%s</a></div>',
			esc_html__( 'Screen Options', 'streamtube-core' )
		);

		echo '<div class="clearfix"></div>';

	endif;
}