<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define the rest functionality.
 *
 * @since      1.0.6
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
class StreamTube_Core_Subtitles_Rest_Controller extends StreamTube_Core_Rest_API {

	/**
	 * @since 1.0.6
	 */
	public function rest_api_init() {

		register_rest_route(
			"{$this->namespace}{$this->version}",
			'/subtitles',
			array(
				'methods'             => WP_REST_Server::CREATABLE,
				'callback'            => array( $this, 'create_item' ),
				'args'                => array(
					'post_id'  => array(
						'validate_callback' => function ($param, $request, $key) {
							return is_numeric( $param ) || is_string( $param );
						}
					),
					'language' => array(
						'validate_callback' => function ($param, $request, $key) {
							return is_numeric( $param ) || is_string( $param );
						}
					)
				),
				'permission_callback' => array( $this, 'check_permission_create_item' )
			)
		);
	}

	public function check_permission_create_item( $request ) {

		if ( ! Streamtube_Core_Permission::can_edit_post( $request['post_id'] ) ) {
			return new WP_Error(
				'no_permission',
				esc_html__( 'Sorry, you are not allowed to edit this video.', 'streamtube-core' ),
				array( 'status' => rest_authorization_required_code() )
			);
		}

		if ( ! $request['language'] ) {
			return new WP_Error(
				'invalid_language',
				esc_html__( 'Invalid language', 'streamtube-core' ),
				array( 'status' => rest_authorization_required_code() )
			);
		}

		return true;
	}

	/**
	 *
	 * Create item
	 * 
	 * @param  WP_Rest_Request $request
	 * @since 1.0.6
	 */
	public function create_item( $request ) {

		$response = new WP_Error( 'no_ai', esc_html__( 'AI is unavailable', 'streamtube-core' ) );

		$response = apply_filters( 'streamtube/core/generate_subtitles', $response, $request );

		if ( is_wp_error( $response ) ) {
			wp_send_json_error( $response, 403 );
		}

		wp_send_json_success( $response );
	}
}