<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 *
 * Get all socials
 * 
 */
function streamtube_core_get_social_options() {
	$socials = array(
		'twitch'        => esc_html__( 'Twitch', 'streamtube-core' ),
		'tiktok'        => esc_html__( 'Tiktok', 'streamtube-core' ),
		'youtube'       => esc_html__( 'Youtube', 'streamtube-core' ),
		'vimeo'         => esc_html__( 'Vimeo', 'streamtube-core' ),
		'pinterest'     => esc_html__( 'Pinterest', 'streamtube-core' ),
		'linkedin'      => esc_html__( 'Linkedin', 'streamtube-core' ),
		'facebook'      => esc_html__( 'Facebook', 'streamtube-core' ),
		'twitter'       => esc_html__( 'Twitter', 'streamtube-core' ),
		'telegram'      => esc_html__( 'Telegram', 'streamtube-core' ),
		'instagram'     => esc_html__( 'Instagram', 'streamtube-core' ),
		'discord'       => esc_html__( 'Discord', 'streamtube-core' ),
		'tumblr'        => esc_html__( 'Tumblr', 'streamtube-core' ),
		'deviantart'    => esc_html__( 'Deviantart', 'streamtube-core' ),
		'snapchat'      => esc_html__( 'Snapchat', 'streamtube-core' ),
		'weibo'         => esc_html__( 'Weibo', 'streamtube-core' ),
		'behance'       => esc_html__( 'Behance', 'streamtube-core' ),
		'whatsapp'      => esc_html__( 'WhatsApp', 'streamtube-core' ),
		'odnoklassniki' => esc_html__( 'Odnoklassniki', 'streamtube-core' ),
		'vkontakte'     => esc_html__( 'Vkontakte', 'streamtube-core' ),
		'wordpress'     => esc_html__( 'WordPress', 'streamtube-core' ),
		'stackoverflow' => esc_html__( 'Stackoverflow', 'streamtube-core' ),
		'flickr'        => esc_html__( 'Flickr', 'streamtube-core' ),
		'github'        => esc_html__( 'Github', 'streamtube-core' )
	);

	return apply_filters( 'streamtube_core_get_social_options', $socials );
}

/**
 *
 * Get defined date ranges
 * 
 * @param  string $date_range
 * @return array
 */
function streamtube_core_get_date_ranges( $date_range = '' ) {
	$date_ranges = array(
		'today'      => esc_html__( 'Today', 'streamtube-core' ),
		'yesterday'  => esc_html__( 'Yesterday', 'streamtube-core' ),
		'week'       => esc_html__( 'Last 7 days', 'streamtube-core' ),
		'this_week'  => esc_html__( 'This week', 'streamtube-core' ),
		'last_week'  => esc_html__( 'Last week', 'streamtube-core' ),
		'month'      => esc_html__( 'Last 30 days', 'streamtube-core' ),
		'this_month' => esc_html__( 'This month', 'streamtube-core' ),
		'last_month' => esc_html__( 'Last month', 'streamtube-core' ),
		'7days'      => esc_html__( 'Last 7 days', 'streamtube-core' ),
		'14days'     => esc_html__( 'Last 14 days', 'streamtube-core' ),
		'15days'     => esc_html__( 'Last 15 days', 'streamtube-core' ),
		'30days'     => esc_html__( 'Last 30 days', 'streamtube-core' ),
		'60days'     => esc_html__( 'Last 60 days', 'streamtube-core' ),
		'90days'     => esc_html__( 'Last 90 days', 'streamtube-core' ),
		'6months'    => esc_html__( 'Last 6 months', 'streamtube-core' ),
		'12months'   => esc_html__( 'Last 12 months', 'streamtube-core' ),
		'this_year'  => esc_html__( 'This year (Jan-Today)', 'streamtube-core' ),
		'last_year'  => esc_html__( 'Last year', 'streamtube-core' ),
		'total'      => esc_html__( 'All time', 'streamtube-core' )
	);

	if ( $date_range && isset( $date_ranges[ $date_range ] ) ) {
		return $date_ranges[ $date_range ];
	}

	/**
	 *
	 * Filter and return ranges
	 *
	 * @param array $date_ranges
	 * 
	 */
	return apply_filters( 'streamtube_core_get_date_ranges', $date_ranges );
}

/**
 *
 * Heading options
 * 
 * @return array
 */
function streamtube_core_get_heading_options() {
	return array(
		'h1' => 'H1',
		'h2' => 'H2',
		'h3' => 'H3',
		'h4' => 'H4',
		'h5' => 'H5',
		'h6' => 'H6'
	);
}

/**
 *
 * Text styles
 * 
 * @return array
 * 
 */
function streamtube_core_get_text_styles() {
	return array(
		'primary'   => esc_html__( 'Primary', 'streamtube-core' ),
		'secondary' => esc_html__( 'Secondary', 'streamtube-core' ),
		'success'   => esc_html__( 'Success', 'streamtube-core' ),
		'danger'    => esc_html__( 'Danger', 'streamtube-core' ),
		'warning'   => esc_html__( 'Warning', 'streamtube-core' ),
		'info'      => esc_html__( 'Info', 'streamtube-core' ),
		'light'     => esc_html__( 'Light', 'streamtube-core' ),
		'white'     => esc_html__( 'White', 'streamtube-core' ),
		'dark'      => esc_html__( 'Dark', 'streamtube-core' ),
		'body'      => esc_html__( 'Body', 'streamtube-core' ),
		'muted'     => esc_html__( 'Muted', 'streamtube-core' )
	);
}

/**
 *
 * Button styles
 * 
 * @return array
 * 
 */
function streamtube_core_get_button_styles() {
	return array(
		'danger'    => esc_html__( 'Danger', 'streamtube-core' ),
		'success'   => esc_html__( 'Success', 'streamtube-core' ),
		'info'      => esc_html__( 'Info', 'streamtube-core' ),
		'secondary' => esc_html__( 'Secondary', 'streamtube-core' ),
		'warning'   => esc_html__( 'Warning', 'streamtube-core' ),
		'light'     => esc_html__( 'Light', 'streamtube-core' ),
		'dark'      => esc_html__( 'Dark', 'streamtube-core' )
	);
}

/**
 *
 * Get thumbnail sizes
 * 
 * @return array
 */
function streamtube_core_get_thumbnail_sizes() {

	$sizes = array(
		'full' => esc_html__( 'full', 'streamtube-core' )
	);

	$default_image_sizes = array( 'thumbnail', 'medium', 'large' );

	global $_wp_additional_image_sizes;

	foreach ( $default_image_sizes as $key ) {
		$sizes[ $key ] = sprintf(
			'%s (%sx%spx)',
			$key,
			intval( get_option( "{$key}_size_w" ) ),
			intval( get_option( "{$key}_size_h" ) )
		);
	}

	if ( ! $_wp_additional_image_sizes ) {
		return $sizes;
	}

	foreach ( $_wp_additional_image_sizes as $key => $value ) {
		$sizes[ $key ] = sprintf( '%s (%sx%spx)', $key, $value['width'], $value['height'] );
	}

	return $sizes;
}

/**
 *
 * Get list type for displaying filter
 * 
 * @return array()
 * 
 */
function streamtube_core_get_list_types() {
	return array(
		'list'  => esc_html__( 'List', 'streamtube-core' ),
		'cloud' => esc_html__( 'Cloud', 'streamtube-core' )
	);
}

/**
 *
 * Get term orderby options
 * 
 * @return array
 *
 * @since 1.0.8
 * 
 */
function streamtube_core_get_term_orderby_options() {
	return array(
		'name'        => esc_html__( 'Name', 'streamtube-core' ),
		'slug'        => esc_html__( 'Slug', 'streamtube-core' ),
		'term_group'  => esc_html__( 'Term Group', 'streamtube-core' ),
		'term_id'     => esc_html__( 'Term ID', 'streamtube-core' ),
		'id'          => esc_html__( 'ID', 'streamtube-core' ),
		'description' => esc_html__( 'Description', 'streamtube-core' ),
		'parent'      => esc_html__( 'Parent', 'streamtube-core' ),
		'count'       => esc_html__( 'Count', 'streamtube-core' )
	);
}

/**
 *
 * Get orderby options
 * 
 * @return array
 *
 * @since 1.0.8
 * 
 */
function streamtube_core_get_orderby_options() {
	$orderby = array(
		'none'          => esc_html__( 'None', 'streamtube-core' ),
		'ID'            => esc_html__( 'Order by post id.', 'streamtube-core' ),
		'author'        => esc_html__( 'Order by author', 'streamtube-core' ),
		'title'         => esc_html__( 'Order by post title', 'streamtube-core' ),
		'name'          => esc_html__( 'Order by post slug', 'streamtube-core' ),
		'date'          => esc_html__( 'Order by date (default)', 'streamtube-core' ),
		'modified'      => esc_html__( 'Order by last modified date.', 'streamtube-core' ),
		'rand'          => esc_html__( 'Random order', 'streamtube-core' ),
		'comment_count' => esc_html__( 'Order by number of comments', 'streamtube-core' ),
		'relevance'     => esc_html__( 'Relevance', 'streamtube-core' )
	);

	if ( apply_filters( 'streamtube_has_pageviews', false ) ) {
		$orderby['post_view'] = esc_html__( 'Order by number of views', 'streamtube-core' );
	}

	return apply_filters( 'streamtube_core_get_orderby_options', $orderby );
}

/**
 *
 * Get order options
 * 
 * @return array
 *
 * @since 1.0.8
 * 
 */
function streamtube_core_get_order_options() {
	return array(
		'ASC'  => esc_html__( 'Ascending', 'streamtube-core' ),
		'DESC' => esc_html__( 'Descending (default).', 'streamtube-core' )
	);
}

/**
 *
 * Get post view types
 * 
 * @return array
 *
 * @since 1.0.8
 * 
 */
function streamtube_core_get_post_view_types() {
	$types = array(
		'pageviews'  => esc_html__( 'Page Views', 'streamtube-core' ),
		'videoviews' => esc_html__( 'Video Views', 'streamtube-core' )
	);

	return $types;
}


/**
 *
 * Get default date ranges
 * 
 * @return array $date_ranges
 *
 * @since  1.0.0
 * 
 */
function streamtube_core_get_default_date_ranges() {
	$date_ranges = array(
		'today'      => esc_html__( 'Today', 'streamtube-core' ),
		'yesterday'  => esc_html__( 'Yesterday', 'streamtube-core' ),
		'7daysAgo'   => esc_html__( 'Last 7 days', 'streamtube-core' ),
		'15daysAgo'  => esc_html__( 'Last 15 days', 'streamtube-core' ),
		'28daysAgo'  => esc_html__( 'Last 28 days', 'streamtube-core' ),
		'90daysAgo'  => esc_html__( 'Last 90 days', 'streamtube-core' ),
		'180daysAgo' => esc_html__( 'Last 180 days', 'streamtube-core' ),
		'all'        => esc_html__( 'All time', 'streamtube-core' )
	);

	/**
	 *
	 * Filter default date ranges
	 *
	 * @param  array $date_ranges
	 *
	 * @since  1.0.0
	 * 
	 */
	return apply_filters( 'streamtube_core_get_default_date_ranges', $date_ranges );
}

/**
 *
 * Get linechart options
 * 
 * @return array
 *
 * @since 1.0.8
 * 
 */
function streamtube_core_get_linechart_options() {

	$theme_mode = function_exists( 'streamtube_get_theme_mode' ) ? streamtube_get_theme_mode() : 'light';

	$options = array(
		'legend'          => array(
			'position'  => 'top',
			'textStyle' => array(
				'color' => '#aaa'
			)
		),
		'chartArea'       => array(
			'width'  => '95%',
			'height' => '600px'
		),
		'hAxis'           => array(
			'format'         => 'dd/MM/YY',
			'titleTextStyle' => array(
				'color' => '#aaa'
			),
			'textStyle'      => array(
				'color'    => '#aaa',
				'fontSize' => 15
			),
			'gridlines'      => array(
				'color' => 'transparent'
			)
		),
		'vAxis'           => array(
			'minValue'  => 0,
			'textStyle' => array(
				'color'    => '#aaa',
				'fontSize' => 15
			),
			'gridlines' => array(
				'color' => $theme_mode == 'light' ? '#e9ecef' : '#333',
				'count' => 3
			)
		),
		//'curveType'			=>	'function',
		'focusTarget'     => 'category',
		'crosshair'       => array(
			'orientation' => 'vertical',
			'trigger'     => 'focus'
		),
		'tooltip'         => array(
			'isHtml'  => true,
			'trigger' => 'focus'
		),
		'series'          => array(
			array(
				'color' => '#4285f4'
			),
			array(
				'color'         => '#4285f4',
				'lineDashStyle' => array( 2, 2 ),
				'lineWidth'     => 1
			)
		),
		'backgroundColor' => 'transparent'
	);

	/**
	 *
	 * Filter the chart options
	 *
	 * @param array $chart_options
	 * 
	 * @since 1.0.8
	 */
	return apply_filters( 'streamtube_core_get_linechart_options', $options );
}

/**
 * Get language list.
 *
 * @see https://gist.github.com/joshuabaker/d2775b5ada7d1601bcd7b31cb4081981
 * 
 * @return array|false The list of languages or false if an error occurred.
 */
function streamtube_core_get_languages() {
	$file_path = STREAMTUBE_CORE_PUBLIC . '/assets/languages.json';

	// Check if the file exists
	if ( ! file_exists( $file_path ) ) {
		// Log or handle the file missing error
		return false;
	}

	// Get the content of the file
	$languages = file_get_contents( $file_path );

	// Check if the content was retrieved successfully
	if ( $languages === false ) {
		// Log or handle the error where the file couldn't be read
		return false;
	}

	// Decode JSON content
	$languages = json_decode( $languages, true );

	// Check for JSON decoding errors
	if ( json_last_error() !== JSON_ERROR_NONE ) {
		// Log or handle the JSON error
		return false;
	}

	// Filter the languages and apply the filter hook
	return apply_filters( 'streamtube_core_get_languages', $languages );
}

/**
 *
 * Get language options
 * 
 * @return array
 */
function streamtube_core_get_language_options() {

	$options = array();

	$languages = streamtube_core_get_languages();

	if ( $languages ) {
		foreach ( $languages as $language ) {
			$options[ $language['code'] ] = sprintf(
				'(%s) - %s - %s',
				strtoupper( $language['code'] ),
				$language['name'],
				$language['native']
			);
		}

		return $options;
	}

	return false;
}

/**
 *
 * Search language by code
 * 
 * @param  string $code
 * @return array|false
 * 
 */
function streamtube_core_get_language_by_code( $code ) {

	$languages = streamtube_core_get_languages();

	if ( ! $languages ) {
		return false;
	}

	$search = array_search( $code, array_column( $languages, 'code' ) );

	if ( $search ) {
		return $languages[ $search ];
	}

	return false;
}

/**
 * Get the ISO 3166-1 alpha-2 country codes.
 * 
 * @return array The array of country codes or an empty array if there's an error.
 */
function streamtube_core_get_iso31661alpha2() {
	// Get the contents of the file
	$file_path = STREAMTUBE_CORE_PUBLIC . '/assets/iso3166-1-alpha-2.json';

	if ( file_exists( $file_path ) ) {
		$code = file_get_contents( $file_path );

		if ( $code === false ) {
			// Log error or handle accordingly if the file could not be read
			return array();
		}

		// Decode JSON content
		$decoded_data = json_decode( $code, true );

		// Check if the JSON is valid
		if ( json_last_error() === JSON_ERROR_NONE ) {
			return $decoded_data;
		} else {
			// Handle JSON decode error
			return array();
		}
	}

	// Return empty array if file doesn't exist
	return array();
}


/**
 *
 * Get all available roles
 * 
 * @return array
 */
function streamtube_get_get_role_options() {
	global $wp_roles;

	$roles = array();

	foreach ( $wp_roles->roles as $role => $value ) {

		$roles[ $role ] = $value['name'];
	}

	return $roles;
}