<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

/**
 *
 * Get current dashboard screen
 * 
 * @return string
 */
function streamtube_get_current_screen( $post_type = '' ){
    return Streamtube_Core_MetaBox::get_current_screen( $post_type );
}

/**
 * Adds a meta box to one or more screens on the frontend dashboard
 * Similiar to add_meta_box()
 *
 * @see Streamtube_Core_MetaBox::add()
 *
 * Hook: `streamtube_add_meta_boxes`
 * 
 */
function streamtube_add_meta_box( $id, $title, $callback, $screen = null, $context = 'normal', $priority = 'default', $callback_args = null ){
    return Streamtube_Core_MetaBox::add( $id, $title, $callback, $screen, $context, $priority, $callback_args );
}

/**
 *
 * Similiar to remove_meta_box()
 *
 * Remove metabox
 *
 * @see Streamtube_Core_MetaBox::remove()
 *
 * Example
 *
 * add_action( 'streamtube_add_meta_boxes', function(){
 *   streamtube_remove_meta_box( 'publish', 'video', 'side' );
 *   streamtube_remove_meta_box( 'publish', 'post', 'side' );
 &  });
 * 
 */
function streamtube_remove_meta_box( $id, $screen, $context = 'normal' ){
    return Streamtube_Core_MetaBox::remove( $id, $screen, $context );
}