<?php
/**
 * Define the Sortby elementor functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Streamtube_Core_Sortby_Elementor extends \Elementor\Widget_Base {

	public function get_name() {
		return 'streamtube-sortby';
	}

	public function get_title() {
		return esc_html__( 'Sort by', 'streamtube-core' );
	}

	public function get_keywords() {
		return array( 'sortby', 'sort by', 'sort', 'streamtube' );
	}

	public function get_categories() {
		return array( 'streamtube' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section-appearance',
			array(
				'label' => esc_html__( 'Appearance', 'streamtube-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT
			)
		);

		$this->add_control(
			'default',
			array(
				'label'   => esc_html__( 'Default', 'streamtube-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'default' => 'date',
				'options' => function_exists( 'streamtube_option_sortby' ) ? streamtube_option_sortby() : array()
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		?>
		<div class="post-sort d-flex">
			<?php
			/**
			 * Fires after before
			 */
			do_action( 'streamtube/core/archive/sortby/before' );

			get_template_part( 'template-parts/sortby', null, $this->get_settings_for_display() );

			/**
			 * Fires after sortby
			 */
			do_action( 'streamtube/core/archive/sortby/after' );
			?>
		</div>
		<?php
	}
}

if ( defined( 'ELEMENTOR_VERSION' ) && version_compare( ELEMENTOR_VERSION, '3.5.0', '<' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Streamtube_Core_Sortby_Elementor() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register( new Streamtube_Core_Sortby_Elementor() );
}