<?php
/**
 * WP Comments List Table
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

if( ! class_exists( 'WP_Comments_List_Table' ) ){
    return;
}

class StreamTube_Core_Comments_List_Table extends WP_Comments_List_Table{

    function __construct( $args = array() ) {
        parent::__construct( $args );

        global $post_id;

        $post_id = isset( $_REQUEST['post_id'] ) ? absint( $_REQUEST['post_id'] ) : 0;

        if ( $args['ajax'] ) {
            add_action( 'wp_footer', array( $this, '_js_vars' ) );        
        }
    }

    /**
     * @global int $post_id
     * @global string $comment_status
     * @global string $comment_type
     */
    protected function get_views() {
        global $post_id, $comment_status, $comment_type;

        $status_links       = array();
        $num_comments       = ( $post_id ) ? wp_count_comments( $post_id ) : new stdClass();

        $moderate_comments  = current_user_can( 'moderate_comments' );

        $current_user_id    = get_current_user_id();

        $statuses = array(
            /* translators: %s: Number of comments. */
            'all'       => _nx_noop(
                'All <span class="count">(%s)</span>',
                'All <span class="count">(%s)</span>',
                'comments'
            ), // Singular not used.

            /* translators: %s: Number of comments. */
            'mine'      => _nx_noop(
                'Mine <span class="count">(%s)</span>',
                'Mine <span class="count">(%s)</span>',
                'comments'
            ),

            /* translators: %s: Number of comments. */
            'moderated' => _nx_noop(
                'Pending <span class="count">(%s)</span>',
                'Pending <span class="count">(%s)</span>',
                'comments'
            ),

            /* translators: %s: Number of comments. */
            'approved'  => _nx_noop(
                'Approved <span class="count">(%s)</span>',
                'Approved <span class="count">(%s)</span>',
                'comments'
            ),

            /* translators: %s: Number of comments. */
            'spam'      => _nx_noop(
                'Spam <span class="count">(%s)</span>',
                'Spam <span class="count">(%s)</span>',
                'comments'
            ),

            /* translators: %s: Number of comments. */
            'trash'     => _nx_noop(
                'Trash <span class="count">(%s)</span>',
                'Trash <span class="count">(%s)</span>',
                'comments'
            ),
        );

        if ( ! EMPTY_TRASH_DAYS ) {
            unset( $statuses['trash'] );
        }

        $mapping       = array(
            'approved'      => 'approve',
            'moderated'     => 'hold',
            'spam'          => 'spam',
            'trash'         => 'trash',
            'post-trashed'  => 'post-trashed',
        );        

        $link = remove_query_arg( array_keys( $_GET ), $_SERVER['REQUEST_URI'] );

        if ( ! empty( $comment_type ) && 'all' !== $comment_type ) {
            $link = add_query_arg( 'comment_type', $comment_type, $link );
        }

        $comment_types = array( 'comment' );

        if( $moderate_comments ){

            $comment_types = array_merge( $comment_types, array( 'trackback', 'pingback' ) );   

            if( function_exists( 'WC' ) ){
               $comment_types[] = 'review';
            }
        }

        if( isset( $_REQUEST['comment_type'] ) ){
            $comment_types = wp_unslash( $_REQUEST['comment_type'] );
        }

        $comment_args = array(
            'post_id'       => $post_id ? $post_id : 0,
            'type'          => $comment_types,
            'count'         => true,
            'orderby'       => 'none'
        );

        foreach ( $statuses as $status => $label ) {
            if ( 'mine' === $status ) {
                $num_comments->mine = get_comments( array_merge( $comment_args, array(
                    'user_id'   =>  $current_user_id
                ) ) );
            } else {

                $comment_args = array_merge( $comment_args, array(
                    'post_author'   => $moderate_comments ? false : $current_user_id,
                    'status'        => array_key_exists( $status , $mapping ) ? $mapping[$status] : $status,                    
                ) );

                $num_comments->$status = get_comments( $comment_args );

            }

            if ( ! isset( $num_comments->$status ) ) {
                $num_comments->$status = 10;
            }

            $link = add_query_arg( 'comment_status', $status, $link );

            if ( $post_id ) {
                $link = add_query_arg( 'post_id', absint( $post_id ), $link );
            }

            /*
            // I toyed with this, but decided against it. Leaving it in here in case anyone thinks it is a good idea. ~ Mark
            if ( !empty( $_REQUEST['s'] ) )
                $link = add_query_arg( 's', esc_attr( wp_unslash( $_REQUEST['s'] ) ), $link );
            */

            $status_links[ $status ] = array(
                'url'     => esc_url( $link ),
                'label'   => sprintf(
                    translate_nooped_plural( $label, $num_comments->$status ),
                    sprintf(
                        '<span class="%s-count">%s</span>',
                        ( 'moderated' === $status ) ? 'pending' : $status,
                        number_format_i18n( $num_comments->$status )
                    )
                ),
                'current' => $status === $comment_status,
            );
        }

        /**
         * Filters the comment status links.
         *
         * @since 2.5.0
         * @since 5.1.0 The 'Mine' link was added.
         *
         * @param string[] $status_links An associative array of fully-formed comment status links. Includes 'All', 'Mine',
         *                              'Pending', 'Approved', 'Spam', and 'Trash'.
         */
        return apply_filters( 'comment_status_links', $this->get_views_links( $status_links ) );
    } 

    protected function get_items_per_page( $option = '', $default_value = 20 ) {
        $per_page = (int)get_user_option( 'edit_'. $this->screen->id .'_per_page' );

        return $per_page !== 0 ? absint( $per_page ) : $default_value;
    }     

    /**
     *
     * Output the quick edit form
     * 
     */
    public function quickedit(){
        ob_start();
        wp_comment_reply( '-1', true, 'detail' );
        $output = ob_get_clean();

        $nonce_field = '<input type="hidden" name="is_frontend" value="on" />';

        $output = preg_replace( '/(<div id="edithead" style="display:none;">)/', '$1' . $nonce_field, $output );

        if( ! current_user_can( 'moderate_comments' ) ){
            $output = preg_replace( '/<div class="inside">\s*<label for="author-email">Email<\/label>.*?<\/div>/s', '', $output );
        }

        echo balanceTags( $output );
    }    

    public function enqueue_scripts(){                
        wp_enqueue_script( 'wp-lists' );
        wp_enqueue_script( 'jquery.query' );
        wp_enqueue_script( 'wp-admin-comments' ); 
        enqueue_comment_hotkeys_js();        
    }          
}