<?php
/**
 *
 * The Text Track template file
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$languages = streamtube_core_get_language_options();
;
$track = $args;
?>
<th scope="row" class="check-column p-1">
	<span class="badge bg-danger text-white count">
	</span>
</th>

<td data-colname="<?php esc_attr_e( 'Language', 'streamtube-core' ) ?>" class="title column-title column-primary">
	<select class="regular-text text_tracks_language select-select2" name="text_tracks[languages][]">

		<option value=""><?php esc_html_e( 'Select', 'streamtube-core' ); ?></option>

		<?php if ( is_array( $languages ) ) : ?>

			<?php foreach ( $languages as $language => $text ) : ?>

				<?php printf(
					'<option value="%s" %s>%s</option>',
					esc_attr( strtolower( $language ) ),
					$language == $track['language'] ? 'selected' : '',
					esc_html( $text )
				); ?>

			<?php endforeach; ?>

		<?php endif; ?>

	</select>

	<button type="button" class="toggle-row">
		<span class="screen-reader-text">
			<?php esc_html_e( 'Show more details', 'streamtube-core' ) ?>
		</span>
	</button>
</td>
<td data-colname="<?php esc_attr_e( 'Source', 'streamtube-core' ) ?>">
	<div class="field-group">
		<div class="input-group">

			<?php printf(
				'<input class="input-field regular-text form-control text-track-field" type="text" name="text_tracks[sources][]" value="%s" placeholder="%s">',
				esc_attr( $track['source'] ),
				esc_attr__( 'Upload a VTT (WebVTT) file', 'streamtube-core' )
			); ?>

			<?php if ( is_admin() ) : ?>
				<button type="button" class="btn btn-secondary button button-secondary button-upload" data-media-type="text"
					data-media-source="url">
					<span class="dashicons dashicons-upload"></span>
				</button>
			<?php else : ?>
				<label class="btn btn-secondary btn-sm button button-small">
					<input name="text_track_file" type="file" accept=".vtt" class="d-none">
					<span class="icon-upload"></span>
				</label>
			<?php endif; ?>
		</div>
	</div>
</td>

<td data-colname="<?php esc_attr_e( 'Action', 'streamtube-core' ) ?>">
	<div class="d-sm-block d-md-flex align-items-start">

		<?php if ( current_user_can( 'ai_generate_subtitles' ) ) : ?>
			<?php printf(
				'<button title="%1$s" type="button" class="mb-3 me-3 track_ai_generator button-small btn btn-info button btn-sm text-white">',
				esc_attr__( 'Generate subtitle with AI', 'streamtube-core' )
			); ?>
			<?php esc_html_e( 'Generate Subtitle with AI', 'streamtube-core' ); ?>
			</button>
		<?php endif; ?>

		<button type="button" class="mb-3 me-3 button btn btn-danger btn-sm button-small track_remove p-1">
			<span class="dashicons dashicons-minus"></span>
		</button>

		<button type="button" class="mb-3 me-3 button btn btn-primary button-primary button-small btn-sm track_add p-1">
			<span class="dashicons dashicons-plus"></span>
		</button>

	</div>
</td>