<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

wp_enqueue_script( 'jquery-ui-sortable' );

$sources      = streamtube_core()->get()->post->get_altsources( $post->ID, false, false );
$source_count = 1;

if ( $sources ) {
	$source_count = count( $sources );
}

?>
<table id="table-altsources" class="wp-list-table widefat fixed striped table-altsources">
	<thead>
		<td id="cb" class="manage-column column-cb check-column p-1"><?php esc_html_e( '#', 'streamtube-core' ); ?></td>
		<th scope="col" class="manage-column column-primary">
			<?php esc_html_e( 'Label (required)', 'streamtube-core' ); ?>
		</th>
		<th scope="col" class="manage-column"><?php esc_html_e( 'Source (required)', 'streamtube-core' ); ?></th>
		<th scope="col" class="manage-column"><?php esc_html_e( 'Action', 'streamtube-core' ); ?></th>
	</thead>

	<tbody id="the-list">
		<?php for ( $i = 0; $i < $source_count; $i++ ) {
			$source = array(
				'label'  => esc_html__( 'Label %s', 'streamtube-core' ),
				'source' => ''
			);

			if ( $sources ) {
				$source = $sources[ $i ];
			}
			;

			printf(
				'<tr class="source-row" id="source-row-%s">',
				$i
			);

			load_template( plugin_dir_path( __FILE__ ) . 'altsource.php', false, $source );

			printf(
				'</tr>'
			);
		} ?>
	</tbody>

	<tfoot>
		<td id="cb" class="manage-column column-cb check-column p-1"><?php esc_html_e( '#', 'streamtube-core' ); ?></td>
		<th scope="col" class="manage-column column-primary">
			<?php esc_html_e( 'Label (required)', 'streamtube-core' ); ?>
		</th>
		<th scope="col" class="manage-column"><?php esc_html_e( 'Source (required)', 'streamtube-core' ); ?></th>
		<th scope="col" class="manage-column"><?php esc_html_e( 'Action', 'streamtube-core' ); ?></th>
	</tfoot>
</table>
<style type="text/css">
	.table-altsources .dashicons {
		font-size: 1rem;
		line-height: 1.5;
	}

	.table-altsources tbody tr:first-child .source_remove {
		display: none;
	}
</style>

<script type="text/javascript">

	function updateSourceRowIndex() {
		jQuery('#table-altsources tbody tr').each(function (index) {
			jQuery(this).find('th .badge.count').html(index + 1);
		});
	}

	jQuery(document).ready(function () {

		updateSourceRowIndex();

		jQuery(document).on('click', 'button.source_add', function () {

			var tr = jQuery(this).closest('tr');
			var trClone = tr.clone();

			jQuery(trClone).find('.input-field').val('');

			tr.after(trClone);

			updateSourceRowIndex();
		});

		jQuery(document).on('click', 'button.source_remove', function () {
			jQuery(this).closest('tr').remove();

			updateSourceRowIndex();
		});

		jQuery("#table-altsources tbody").sortable({
			update: function (event, ui) {
				updateSourceRowIndex();
			}
		});

	});

</script>