<?php
/**
 * Define Posts List Table filter
 *
 * @since      1.0.0
 * @package    WP_Cloudflare_Stream
 * @subpackage WP_Cloudflare_Stream/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

class WP_Cloudflare_Stream_Posts_List_Table {
    /**
     *
     * Add `Live` item
     * 
     */
    public function filter_status_links( $status_links, $post_type, $url ){
        if( $post_type === 'video' ){
            $status_links['live_stream'] = array(
                'url'     => add_query_arg( array( 'post_status' => 'live_stream' ), $url ),
                'label'   => esc_html__( 'Live Streaming', 'wp-cloudflare-stream' ),
                'current' => isset( $_REQUEST['post_status'] ) && $_REQUEST['post_status'] == 'live_stream' ? true : false
            );
        }
        return $status_links;
    }

    /**
     *
     * Filter
     * 
     */
    public function filter_query_args( $q, $post_type, $wp_query ){
        if( isset( $_REQUEST['post_status'] ) && wp_unslash( $_REQUEST['post_status'] ) === 'live_stream' ){
            $q = wp_parse_args( $q, array(
                'meta_query'    =>  array()
            ) );

            $q['meta_query'][] = array(
                'key'   =>  'live_status'
            ); 
        }
        return $q;
    }    

}