<?php
/**
 * Define Cloudflare Stream API 
 *
 * @since      1.0.0
 * @package    WP_Cloudflare_Stream
 * @subpackage WP_Cloudflare_Stream/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

class WP_Cloudflare_Stream_Permission{

    /**
     * Get BunnyCDN capabilities
     *
     * Returns an object with capabilities mapped to specific permission keys.
     *
     * @return object
     */
    public static function get_capabilities() {
        return (object) array(
            'view_encode_logs'      => 'cloudflare_view_encode_logs',
            'view_stream'           => 'cloudflare_view_stream',
            'list_videos'           => 'cloudflare_list_videos',
            'list_others_videos'    => 'cloudflare_list_others_videos',
            'manual_sync'           => 'cloudflare_manual_sync',
            'create_live'           => 'cloudflare_create_live',
            'create_lives'          => 'cloudflare_create_lives',
        );
    }    

    public static function edit_post( $post ){

        if( ! is_object( $post ) ){
            $post = get_post( $post );
        }

        return current_user_can( get_post_type_object( $post->post_type )->cap->edit_post, $post->ID );
    }

    /**
     * Check permission to view encode logs
     *
     * @return bool
     */
    public static function view_encode_logs() {
        return current_user_can( self::get_capabilities()->view_encode_logs );
    }

    /**
     * Check permission to view the stream
     *
     * @return bool
     */
    public static function manual_sync() {
        return current_user_can( self::get_capabilities()->manual_sync );
    }    

    /**
     * Check permission to view the stream
     *
     * @return bool
     */
    public static function view_stream() {
        return current_user_can( self::get_capabilities()->view_stream );
    }

    /**
     * Check permission to list videos
     *
     * @return bool
     */
    public static function list_videos() {
        return current_user_can( self::get_capabilities()->list_videos );
    }

    /**
     * Check permission to list others videos
     *
     * @return bool
     */
    public static function list_others_videos() {
        return current_user_can( self::get_capabilities()->list_others_videos );
    }    

    /**
     * Check permission to import videos
     *
     * @return bool
     */
    public static function import_videos() {
        return current_user_can( get_post_type_object( 'video' )->cap->create_posts );
    }

    /**
     * Check permission to import videos
     *
     * @return bool
     */
    public static function import_others_videos() {
        return  current_user_can( get_post_type_object( 'video' )->cap->create_posts ) &&
                current_user_can( get_post_type_object( 'video' )->cap->edit_others_posts );
    }      

    /**
     * Check permission to delete videos
     *
     * @return bool
     */
    public static function delete_videos() {
        return current_user_can( get_post_type_object( 'video' )->cap->delete_posts );
    }

    /**
     * Check permission to delete otherse videos
     *
     * @return bool
     */
    public static function delete_others_videos() {
        return current_user_can( get_post_type_object( 'video' )->cap->delete_others_posts );
    } 

    /**
     * Check permission to create live stream
     *
     * @return bool
     */
    public static function create_live(){
        return  current_user_can( get_post_type_object( 'video' )->cap->create_posts ) && 
                ( 
                    current_user_can( self::get_capabilities()->create_live ) ||
                    current_user_can( 'live_stream' )
                );
    }

    /**
     * Check permission to create live streams
     *
     * @return bool
     */
    public static function create_lives(){
        return  current_user_can( get_post_type_object( 'video' )->cap->create_posts ) && 
                current_user_can( self::get_capabilities()->create_lives );
    }    
}