<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

$is_error 			= '';
$status 			= '';

$cloudflare 		= wp_cloudflare_stream()->get()->post;
$uid 				= $cloudflare->get_stream_uid( $args['attachment_id'] );
$is_ready_stream 	= false;

if( $uid ){

	$is_ready_stream = $cloudflare->is_ready_to_stream( $args['attachment_id'], $uid );

	if( is_wp_error( $is_ready_stream ) ){
		$status 	= $is_ready_stream->get_error_code();
		$is_error 	= true;
	}else{
		$status 	= esc_html__( 'Ready', 'wp-cloudflare-stream' );
	}
}

printf(
	'<div id="status-attachment-%1$s" class="status-attachment" data-attachment-id="%1$s" data-status="%2$s">',
	$args['attachment_id'],
	sanitize_html_class( strtolower($status) )
);

	if( $uid ){

		printf(
			'<p><span class="badge %1$s bg-%2$s">%3$s</span></p>',
			$is_error ? 'bg-danger' : '',
			sanitize_html_class( strtolower($status) ),
			ucwords( substr( $status, 0, 15 ) )
		);

		if( WP_Cloudflare_Stream_Permission::view_encode_logs() ){
	        printf(
	            '<a class="thickbox button button-small" href="%s">%s</a>',
	            esc_url( add_query_arg( array(
	                'action'        =>  'admin_get_cloudflare_error',
	                'attachment_id' =>  $args['attachment_id'],
	                'TB_iframe'     =>  true,
	                'width'         =>  700,
	                'height'        =>  400
	            ), admin_url( 'admin-ajax.php' ) ) ),
	            esc_html__( 'Logs', 'streamtube-core' )
	        );
    	}
	}else{
		if( WP_Cloudflare_Stream_Permission::manual_sync() ){
		    printf(
		        '<button type="button" class="button button-small button-cloudflare-sync button-primary" data-nonce="%s" data-attachment-id="%s">%s</button>',
		        esc_attr( wp_create_nonce( 'cloudflare-sync-' . $args['attachment_id'] ) ),
		        esc_attr( $args['attachment_id'] ),
		        esc_html__( 'Sync', 'streamtube-core' )
		    );
	    }		
	}

echo '</div>';