<?php
/**
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      1.0.0
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $args ) ) {
	$args = array();
}

$args = wp_parse_args( $args, array(
	'default' => 'date'
) );

/**
 * Filters the default sorting option
 *
 * This filter allows customization of the default sorting option used in the StreamTube theme.
 *
 * @param mixed $default The default sorting option. This value is passed from the `$args['default']` array key.
 *
 * @hook streamtube/core/sortby/default
 */
$default = apply_filters( 'streamtube/core/sortby/default', $args['default'] );

/**
 * Retrieves the sorting options
 *
 */
$options = streamtube_option_sortby();

$current = isset( $_GET['orderby'] ) ? sanitize_key( $_GET['orderby'] ) : $default;

if ( empty( $current ) || ! array_key_exists( $current, $options ) ) {
	$current = 'date';
}
?>
<div class="sortby dropdown">
	<button class="btn shadow-none dropdown-toggle text-secondary p-2" data-bs-toggle="dropdown"
		data-bs-display="static" aria-expanded="false">
		<?php printf(
			esc_html__( 'Sort by %s', 'streamtube' ),
			'<strong>' . $options[ $current ] . '</strong>'
		); ?>
	</button>
	<ul class="dropdown-menu animate slideIn">

		<?php foreach ( $options as $key => $value ) : ?>

			<?php printf(
				'<li><a class="py-2 dropdown-item small %s" href="%s">%s</a></li>',
				$current == $key ? 'active' : '',
				esc_url( add_query_arg( array(
					'orderby' => $key,
					'order'   => $key == 'title' ? 'ASC' : 'DESC'
				) ) ),
				esc_html( $value )
			); ?>

		<?php endforeach; ?>
	</ul>
</div>