(function($) {
    "use strict";

    $( document ).on( 'click', '.notice-verify-purchase button.notice-dismiss', function(e){
        $.post( streamtube_admin.ajaxurl + '?action=dismiss_verify_purchase', function( data, status ){
            console.log( status );
        } );

    } );

    $( document ).on( 'click', 'form#verify-license-form button[name=button-verify]', function(e){
        e.preventDefault();

        var button      = $(this);
        var form        = button.closest( 'form' );

        var formData    = new FormData(form[0]);

        var jqxhr = $.ajax({
            url             : streamtube_admin.ajaxurl,
            data            : formData,
            processData     : false,
            contentType     : false,
            type            : 'POST',         
            beforeSend: function( jqXHR ) {
                button.attr( 'disabled', 'disabled' );

                form.addClass( 'processing' ).find( '.verify-notice' ).remove();
            }
        });

        jqxhr.fail( function( jqXHR, textStatus, errorThrown ){
            form.prepend( '<div class="verify-notice notice notice-error"><p>'+ errorThrown +'</p></div>' );
        });

        jqxhr.done( function( data, textStatus, jqXHR ){

            if( data.success == false ){
                form.removeClass( 'verified' ).prepend( '<div class="verify-notice notice notice-error"><p>'+ data.data[0].message +'</p></div>' );
            }else{
                form.addClass( 'verified' ).prepend( '<div class="verify-notice notice notice-success"><p>'+ data.data +'</p></div>' );
            }
        });

        jqxhr.always( function( jqXHR, textStatus ){
            button.removeAttr( 'disabled' );

            form.removeClass( 'processing' );
        });

    } );

    $( document ).on( 'click', 'form#verify-license-form button[name=button-check-update]', function(e){
        e.preventDefault();

        var button      = $(this);
        var form        = button.closest( 'form' );

        var formData    = new FormData(form[0]);

        formData.set( 'action', 'streamtube/license/check_update' );

        var jqxhr = $.ajax({
            url             : streamtube_admin.ajaxurl,
            data            : formData,
            processData     : false,
            contentType     : false,
            type            : 'POST',         
            beforeSend: function( jqXHR ) {
                button.attr( 'disabled', 'disabled' );

                form.addClass( 'processing' ).find( '.verify-notice' ).remove();
            }
        });

        jqxhr.fail( function( jqXHR, textStatus, errorThrown ){
            form.prepend( '<div class="verify-notice notice notice-error"><p>'+ errorThrown +'</p></div>' );
        });

        jqxhr.done( function( data, textStatus, jqXHR ){
            if( data.success == false ){
                form.prepend( '<div class="verify-notice notice notice-error"><p>'+ data.data[0].message +'</p></div>' );
            }else{
                form.prepend( '<div class="verify-notice notice notice-success"><p>'+ data.data +'</p></div>' );
            }
        });

        jqxhr.always( function( jqXHR, textStatus ){
            button.removeAttr( 'disabled' );
            form.removeClass( 'processing' );
        });        
    });

    $( document ).on( 'click', 'form#verify-license-form button[name=button-deregister]', function(e){
        e.preventDefault();

        var button      = $(this);
        var form        = button.closest( 'form' );

        var formData    = new FormData(form[0]);

        formData.set( 'action', 'streamtube/license/deregister' );

        var jqxhr = $.ajax({
            url             : streamtube_admin.ajaxurl,
            data            : formData,
            processData     : false,
            contentType     : false,
            type            : 'POST',         
            beforeSend: function( jqXHR ) {
                button.attr( 'disabled', 'disabled' );
                form.addClass( 'processing' ).find( '.verify-notice' ).remove();
            }
        });

        jqxhr.fail( function( jqXHR, textStatus, errorThrown ){
            form.prepend( '<div class="verify-notice notice notice-error"><p>'+ errorThrown +'</p></div>' );
        });

        jqxhr.done( function( data, textStatus, jqXHR ){
            if( data.success == false ){
                form.prepend( '<div class="verify-notice notice notice-error"><p>'+ data.data[0].message +'</p></div>' );
            }else{
                form.removeClass( 'verified' ).prepend( '<div class="verify-notice notice notice-success"><p>'+ data.data +'</p></div>' );
            }
        });

        jqxhr.always( function( jqXHR, textStatus ){
            button.removeAttr( 'disabled' );
            form.removeClass( 'processing' );
        });        
    });
})(jQuery);