<?php
/**
 *
 * @link              https://1.envato.market/qny3O5
 * @since             1.0.0
 * @package           WP_User_Channel
 *
 * @wordpress-plugin
 * Plugin Name:       WP User Channel
 * Plugin URI:        https://1.envato.market/qny3O5
 * Description:       Enables members to create their own channels, designed specifically for the <a target="_blank" href="https://1.envato.market/qny3O5">StreamTube</a> theme.
 * Version:           1.2
 * Requires at least: 5.3
 * Tested up to:      5.8
 * Requires PHP:      5.6
 * Author:            phpface
 * Author URI:        https://1.envato.market/mgXE4y
 * License:           Themeforest Licence
 * License URI:       http://themeforest.net/licenses
 * Text Domain:       wp-user-channel
 * Domain Path:       /languages
 * Requires Plugins:  streamtube-core
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'WP_USER_CHANNEL', pathinfo( basename( __FILE__ ), PATHINFO_FILENAME ) );

define( 'WP_USER_CHANNEL_BASE', plugin_basename( __FILE__ ) );

define( 'WP_USER_CHANNEL_PATH', plugin_dir_path( __FILE__ ) );

define( 'WP_USER_CHANNEL_URL', plugin_dir_url( __FILE__ ) );

require plugin_dir_path( __FILE__ ) . 'includes/wp-user-channel-loader.php';

/**
 * The code that runs during plugin activation.
 */
function activate_wp_user_channel() {
	WP_User_Channel::activate();
}
register_activation_hook( __FILE__, 'activate_wp_user_channel' );

function WPUChannel() {

	global $wpuchannel;

	if ( ! $wpuchannel ) {
		$wpuchannel = new WP_User_Channel();
	}

	return $wpuchannel;
}

// Run
WPUChannel();