(function($) {
    "use strict";

    $(document.body).on('wp_user_channel/create_channel', function(event, data) {

        if (data.success == false) {
            return $.showToast(data.data[0].message, 'danger', 50000 );
        } else {

            $.get(streamtube.ajaxUrl, {
                action: 'wp_user_channel/get_channel_list',
                _wpnonce: streamtube._wpnonce
            }, function(response) {
                if (response.success == true) {
                    $('.channel-list-container').html( '<ul class="channel-list list-group list-group-flush">' + response.data + '</ul>' );
                }
            });

            $.showToast(data.data, 'success');
        }
    });

    $( document ).on( 'click', '.switch-to-url', function( event ){
        event.preventDefault();
        var button  = $(this);
        var url     = button.attr( 'href' )
        var nonce   = button.attr( 'data-nonce' );
        var userId  = button.attr( 'data-user-id' );

        $.post(streamtube.ajaxUrl, {
            action: 'wp_user_channel/switch_to',
            user_id : userId,
            _wpnonce: nonce
        }, function(response) {
            if (response.success == false ) {
                $.showToast(response.data[0].message, 'danger', 50000 );
            }
            else{
                if( url == '#' ){
                    location.reload();        
                }
                else{
                    window.location.href = url;
                }
            }
        });
    } );  

    $(document).on('click', '.user-navbar #nav-channels a', function(event) {
        $('#modal-channel').modal('show');
    });

    $(document).on('show.bs.modal', '#modal-channel', function(event) {
        let modal = $(this);
        $.get(streamtube.ajaxUrl, {
            action: 'wp_user_channel/get_channel_list',
            _wpnonce: streamtube._wpnonce
        }, function(response) {
            if (response.success === false) {
                modal.find('.modal-body').html('<div class="text-center p-4 text-muted">' + response.data[0].message + '</div>');
                return;
            }

            modal.find('.modal-body').html('<ul class="channel-list list-group list-group-flush">' + response.data + '</ul>');

        });
    });

})(jQuery);