<?php
/**
 *
 * The Create Channel Form template file
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      1.0.0
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
    exit;
}

?>
<div class="create-channel-container p-4 mb-4 shadow-sm bg-white">

	<?php
	/**
	 * Fires before form
	 */
	do_action( 'wp_user_channel/create_form/before' );
	?>	

	<form method="post" class="form-ajax">

		<?php
		/**
		 * Fires before Channel Name field
		 */
		do_action( 'wp_user_channel/create_form/channel/before' );

		streamtube_core_the_field_control( array(
		    'label'         =>  esc_html__( 'Channel Name', 'wp-user-channel' ),
		    'type'          =>  'text',
		    'name'          =>  'channel_name',
		    'autocomplete'	=>	false
		) );

		/**
		 * Fires after Channel Name field
		 */
		do_action( 'wp_user_channel/create_form/channel/after' );
		?>

		<?php printf(
			'<button type="submit" class="btn btn-primary btn-sm"><span class="btn__icon icon-plus"></span> %s</button>',
			esc_html__( 'Create', 'wp-user-channel' )
		);?>	

		<?php
		/**
		 * Fires after Submit button field
		 */
		do_action( 'wp_user_channel/create_form/submit/after' );
		?>		

		<input type="hidden" name="action" value="wp_user_channel/create_channel">

		<?php wp_nonce_field( 'wp_user_channel/create_channel_' . get_current_user_id(), 'create_channel' );?>

	</form>

	<?php
	/**
	 * Fires after form
	 */
	do_action( 'wp_user_channel/create_form/after' );
	?>		
</div>