<?php
/**
 *
 * The List Channel template file
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      1.0.0
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
    exit;
}

$can_switch  = WPUChannel()->can_switch_to( $user->ID );
$profile_url = get_author_posts_url( $user->ID );

printf(
    '<li data-channel-id="%s" class="channel-item list-group-item bg-white border-bottom py-3">',
    esc_attr( $user->ID )
);
?>
    <div class="d-flex gap-4">

        <div class="channel-img position-relative">

            <?php
            /**
             * Fires before channel avatar
             */
            do_action( 'wp_user_channel/channel_avatar/before', $user );
            ?>            

            <?php 
            printf(
                '<a href="%s" title="%s">%s</a>',
                esc_url( $profile_url ),
                sprintf( esc_attr__( 'Go to %s profile', 'wp-user-channel' ), $user->display_name ),
                get_avatar( $user->ID, 50, '', '', array(
                    'class' =>  'img-thumbnail rounded-circle'
                ) )
            );?>

            <?php
            /**
             * Fires after channel avatar
             */
            do_action( 'wp_user_channel/channel_avatar/after', $user );
            ?>

        </div>

        <div class="channel-meta">

            <?php
            /**
             * Fires before channel meta
             */
            do_action( 'wp_user_channel/channel_meta/before', $user );
            ?>

            <?php printf(
                '<p class="mb-1"><a class="fw-bold text-body channel-name text-decoration-none" href="%s" title="%s">%s</a></p>',
                esc_url( $profile_url ),
                sprintf( esc_attr__( 'Go to %s profile', 'wp-user-channel' ), $user->display_name ),
                $user->display_name
            ); ?>

            <?php
            /**
             * Fires after channel meta
             */
            do_action( 'wp_user_channel/channel_meta/after', $user );
            ?>

        </div>

        <div class="ms-auto d-flex gap-4">
            <?php 
            if( $can_switch ){

                printf(
                    '<a href="%s" data-nonce="%s" data-user-id="%s" data-method="post" class="switch-to-url text-body fw-bold text-decoration-none"><span class="icon-cog"></span> %s</a>',
                    esc_url( untrailingslashit( get_author_posts_url( $user->ID ) ) . '/dashboard/settings' ),
                    esc_attr( wp_create_nonce( 'wpuc_switch_to_user_' . $user->ID ) ),
                    esc_attr( $user->ID ),
                    esc_html__( 'Settings', 'wp-user-channel' )
                );

                printf(
                    '<a class="switch-to-url fw-bold text-decoration-none" data-nonce="%s" data-user-id="%s" data-method="post" href="#" title="%s"><span class="icon-arrows-cw text-info"></span></a>',
                    esc_attr( wp_create_nonce( 'wpuc_switch_to_user_' . $user->ID ) ),
                    esc_attr( $user->ID ),
                    sprintf( esc_attr__( 'Switch to %s', 'wp-user-channel' ), $user->display_name ),
                );
            }else{
                echo get_current_user_id() === $user->ID ? '<span class="icon-ok text-success"></span>' : '';
            }?>
        </div>
    </div>
</li>