(function($) {
    "use strict";

    $( document ).on( 'click', 'button.button-assign-channel-cap', function( event ){
        event.preventDefault();

        let button = $(this);
        let userId = button.attr( 'data-user-id' );
        let nonce  = button.attr( 'data-nonce' );
        button.attr( 'disabled', 'disabled' );
        $.post( streamtube_admin.ajaxurl, {
            action  : 'wp_user_channel/assign_channel_cap',
            user_id : userId,
            nonce   : nonce
        }, function( response ){
            if( response.success == false ){
                alert( data.data[0].message );
            }else{
                button.replaceWith( response.data );
            }
        } );
    } );

    $( document ).on( 'change', 'input.wpuc-allow-role', function( event ){
        let field   = $(this);
        let role    = field.val();
        let nonce   = field.attr( 'data-nonce' );
        field.attr( 'disabled', 'disabled' );

        $.post( streamtube_admin.ajaxurl, {
            action  : 'wp_user_channel/assign_role_cap',
            role    : role,
            nonce   : nonce
        }, function( response ){
            if( response.success == false ){
                alert( data.data[0].message );
            }

            field.removeAttr( 'disabled' );
        } );
    } );

})(jQuery);