<?php
/**
 * SantaPress Template for embedding single door posts via iFrame.
 *
 * @package SantaPress
 * @since    1.4.2
 */

add_action('wp_head', 'sp_iframe_styles', 100);

function sp_iframe_styles() {
?>
<style>
html, body {
	margin: 0 !important;
	padding: 0 !important;;
}
* {
	visibility: hidden;
}
#sp_main_wrap * {
	visibility: visible;
}
#sp_main_wrap div.wpcf7 .ajax-loader {
	visibility: hidden;
}
.santapress-post.modal {
	-webkit-transform: scale(1);
    -ms-transform: scale(1);
    transform: scale(1);
    min-height: 100%;
}
.santapress-post.modal .santapress-post-inner {
	height: auto;
}
.modal { display:block !important; width: 100% !important }
</style>
<?php } 
wp_head();
?>

	<div id="sp_main_wrap">
		<?php
		while ( have_posts() ) :
			the_post();
			the_content();
		endwhile;
		?>
	</div>

	<script>
	jQuery(document).ready(function($){
		var getDocumentHeight = function() {
			if (location.hash === '') { // EDIT: this should prevent the retriggering of onDOMReady
				location.hash = $('#sp_main_wrap').height(); 
			}
		};
		$(getDocumentHeight);
	});
	</script>

<?php
get_footer();