<?php
/**
 * SantaPress main plugin file
 *
 * Plugin Name:       SantaPress
 * Plugin URI:        https://santapress.halloecho.de
 * Description:       SantaPress - WordPress Advent Calender Plugin & Quiz for the Christmas season
 * Version:           1.8.0
 * Author:            codemuc
 * Author URI:        https://codemuc.de
 * Text Domain:       santapress
 * Domain Path:       /languages
 *
 * @link              https://santapress.halloecho.de
 * @since             1.0.0
 * @package           SantaPress
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Current plugin version.
 */
define( 'SANTAPRESS_VERSION', '1.8.0' );

/**
 * The code that runs during plugin activation.
 */
function santapress_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-santapress-activator.php';
	Santapress_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function santapress_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-santapress-deactivator.php';
	Santapress_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'santapress_activate' );
register_deactivation_hook( __FILE__, 'santapress_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-santapress.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function santapress_run() {

	$plugin = new Santapress();
	$plugin->run();

}
santapress_run();

// Plugin Setup Manager 
if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}