/**
 * SantaPress Public JavaScript
 *
 * @link       https://santapress.halloecho.de
 * @since      1.0.0
 *
 */
(function( $ ) {
	'use strict';
	
	// Open modal in AJAX callback
	$(function() {

		$( document ).on( 'click', '.santapress-modal', function() {
			event.preventDefault();
			$('body').addClass('sp-modal-wrapper');
			this.blur(); // Manually remove focus from clicked link.
			var postid = $(this).parent().parent().data('postid');
			// embed mode: iframe (since 1.4.2)
			if(this.href.indexOf('embed') !== -1) {
				// load via iframe
				var $el = $('<div class="sp-modal-iframe"><iframe id="sp-iframe" src="'+this.href+'" width="100%" height="100%" frameborder="0" scrolling="no"></iframe></div>');
				$el.appendTo('body').spmodal({
					fadeDuration: 200,
					clickClose: false
				});
				var $iframe = $el.find('iframe');
				var getIFrameHeight = function() {
					setTimeout( function() {
					    var iFrame = $iframe[0];
					    var strHash = iFrame.contentDocument.location.hash;
					    var newHeight = strHash.substring(1);
					    $el.addClass('iframeloaded').height(Math.floor(newHeight));
					    // add modal open class to body (e.g. for snow delay)
						setTimeout(function(){
							$('body').addClass('modal-open');
						}, 350);
					 }, 50);
				};
				$iframe.bind('load', getIFrameHeight );
				// Track
				$.ajax({
					url: data.ajaxurl,
					data: {
			            action: 'sp_track_iframe',
			            postid: postid,
			            nonce: $('#sp-nonce').val()
			        },
					success: function () {
						// success
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						console.log(errorThrown);
					}
				});
			}
			// embed mode: ajax (since 1.4.2)
			else {
				// load via ajax
				$.ajax({
					dataType: 'html',
					url: data.ajaxurl,
					data: {
			            action: 'sp_fetch_door',
			            postid: postid,
			            nonce: $('#sp-nonce').val()
			        },
					success: function (result) {
						//var $el = $(result).find(".santapress-post").eq(0);
						var $el = $($.parseHTML(result.trim(), document, true));
						if(!$el)
							console.log("SantaPress: Something went wrong while fetching the door. Please make sure your theme is using the the_content(); for displaying the post content. See also https://santapress.halloecho.de/docs#faq-01-theme-support.");
						$el.hide();
						$el.appendTo('body').spmodal({
							fadeDuration: 200,
							clickClose: false
						});
						// WPCF7 integration
						if($el.html().indexOf('wpcf7') !== -1) {
							wpcf7.init( $el.find('.wpcf7-form')[0] );
						}
						// add modal open class to body (e.g. for snow delay)
						setTimeout(function(){
							$('body').addClass('modal-open');
						}, 350);
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						console.log(errorThrown);
					}
				});
			}
			$(this).addClass('open');
		});
		$('.santapress-modal').each(function() {
			$(this).addClass('loaded');
		});
		$(document).on($.spmodal.CLOSE, function() {
			$('.santapress-modal').removeClass('open');
			$('body').removeClass('modal-open');
		});

		// Append Snow
		if( $('.santapress-container').hasClass('with-snow') ) {
			// Get snowcond and snowtype
			var snowcond = $('.santapress-container').data('snowcond');
			var snowtype = $('.santapress-container').data('snowtype');
			if(snowtype == 'santapress') {
				if(snowcond == 'modal') {
					$('body').addClass('santapress-snow-modal');
				}
				if(snowcond == 'everywhere') {
					$('<div class="spsnow"></div>').appendTo('body'); // appent snow container to body
					$('body').addClass('santapress-snow-everywhere');
					if( !$('.santapress-container').hasClass('hiddenmode') ) {
						setTimeout(function(){
							$('body').addClass('santapress-snow-everywhere-active');
						}, 400);
					}
				}
			}
		}

		// Hidden mode
		if( $('.santapress-container').hasClass('hiddenmode') ) {
			$('.santapress-container').appendTo('body').removeClass('hiddenmode').wrap('<div class="santapress-container-outer"></div>');
			var timeout = $('.santapress-container').data('timeout');
			var hideafterclose = $('.santapress-container').data('hideafterclose');
			var hideCalender = false;
			if( (hideafterclose == 'session' || hideafterclose == 'midnight' || typeof hideafterclose === 'number') && sp_getcookie('sp_hm_exp') )
				hideCalender = true;
			// fadeIn calendar and reinforce cookie to be set if shortcode variable was changed
			if ((hideafterclose == 'session' && sp_getcookie('sp_hm_exp') !== 'session') ||
				(hideafterclose == 'midnight' && sp_getcookie('sp_hm_exp') !== 'midnight') ||
				(typeof hideafterclose === 'number' && sp_getcookie('sp_hm_exp') !== 'h') ) {
				hideCalender = false;
			}
			if(!hideCalender) {
				// fadeIn calendar
				if(timeout > 0) {
					setTimeout(function(){
						$('.santapress-container-outer').fadeIn().addClass('active');
						$('body').addClass('santapress-snow-everywhere-active');
						// if variable 'hide_after_close' is set in shortcode set expiration cookies
						if(hideafterclose) {
							if(hideafterclose == 'session')
								document.cookie = encodeURIComponent('sp_hm_exp') + "=" + encodeURIComponent( 'session' ) + "; path=/";
							else if(hideafterclose == 'midnight') {
								var d = new Date(); // create new date object for cookie expiration
								d.setHours(24,0,0,0); // set date to next midnight
								var expires = "; expires=" + d.toGMTString();
								document.cookie = encodeURIComponent('sp_hm_exp') + "=" + encodeURIComponent( 'midnight' ) +  expires + "; path=/";
							}
							else if( typeof hideafterclose === 'number' && hideafterclose % 1 === 0 ) { // check if variable is an integer
								var d = new Date(); // create new date object for cookie expiration
								d.setTime(d.getTime() + (hideafterclose*60*60*1000));
								var expires = "; expires=" + d.toGMTString();
								document.cookie = encodeURIComponent('sp_hm_exp') + "=" + encodeURIComponent( 'h' ) +  expires + "; path=/";
							}
							else {
								console.log('SantaPress: Something is wrong with the variable "hide_after_close" you have provided in the shortcode: ' + hideafterclose);
							}
						}
					}, timeout);
				}
			}
			// Trigger
			var triggerClass = $('.santapress-container').data('trigger');
			$( document ).on( 'click', triggerClass, function() {
				$('.santapress-container-outer').fadeIn().addClass('active');
				$('body').addClass('santapress-snow-everywhere-active');
			});
			// Prepend buildin trigger container
			if($('#santapress-trigger').length) {
				$('#santapress-trigger').prependTo('body');
			}
		}
		$( document ).on( 'click', '#sp-close-hidden-mode', function() {
			$('.santapress-container-outer').removeClass('active').fadeOut();
			$('body').removeClass('santapress-snow-everywhere-active');
		});

		// Quiz
		$( document ).on( 'click', '.spquiz-answer', function(event) {
			event.preventDefault();
			this.blur(); // Manually remove focus from clicked link.
			var $loader = $(this).find('.spquiz-loader');
			var $answers_wrapper = $(this).parent();
			var $quiz_wrapper = $(this).parent().parent();
			var $result_wrapper = $(this).parent().parent().find('.spquiz-result');
			var userAnswer = $(this).text();
			var door_post_id = $(this).parent().parent().data('postid');
			$loader.show();
			$.ajax({
				url: data.ajaxurl,
				data: {
		            action: 'sp_quiz_answer',
		            postid: $(this).parent().parent().data('postid'),
		            answer: encodeURIComponent($(this).text()),
		            nonce: $('#sp-nonce').val()
		        },
				success: function (result) {
					$loader.hide();
					$answers_wrapper.hide();
					// wpforms modification
					if(result.indexOf('wpforms') !== -1) {
					    // remove script elements
					    var tempDiv = $('<div>').html(result);
					    $(tempDiv).find("script").remove();
					    $result_wrapper.html(tempDiv.html()).fadeIn();
					    // modify form action
					    $result_wrapper.find('form').attr('action', 'index.php?page_id='+door_post_id);
					}
					else {
						$result_wrapper.html(result).fadeIn();
						// check if a wpcf7 form was returned and initialize if needed
						if(result.indexOf('wpcf7') !== -1) {
							//console.log("init form");
							//console.log( $result_wrapper.find('.wpcf7-form') );
							wpcf7.init( $result_wrapper.find('.wpcf7-form')[0]  );
							// populate wpcf7 hidden fields
							if( $('input[name="santapress_title"]').length ) {
								$('input[name="santapress_title"]').val($quiz_wrapper.parent().find('h1.santapress-title').text());
							}
							if( $('input[name="santapress_question"]').length ) {
								$('input[name="santapress_question"]').val($quiz_wrapper.find('.spquiz-question').text());
							}
							if( $('input[name="santapress_answer"]').length ) {
								$('input[name="santapress_answer"]').val(userAnswer);
							}
							if( $('input[name="santapress_firma"]').length ) {
								$('input[name="santapress_firma"]').val($quiz_wrapper.parent().find('#firma').text()).change();
								$('input[name="santapress_firma"]').attr('value', $quiz_wrapper.parent().find('#firma').text());
							}
						}
					}
					// adjust iframe height if iframe is used (#sp_main_wrap is only used for iframe)
					if($('#sp_main_wrap').length) {
						var iframe_wrap_height = Math.floor($('#sp_main_wrap').height());
						$('#sp-iframe', window.parent.document).height(iframe_wrap_height);
						$('.sp-modal-iframe', window.parent.document).height(iframe_wrap_height);
					}
					// set quiz cookie if needed
					if( $quiz_wrapper.data('qc') == 1 ) {
						var d = new Date(); // create new date object for cookie expiration
						d.setHours(24,0,0,0); // set date to next midnight
						var expires = "; expires=" + d.toGMTString();
						var postid = $quiz_wrapper.data('postid');
						if($quiz_wrapper.data('qctype') == 1) { // set cookie after an answer 
							setTimeout(function(){
								var sp_quiz_cookie = sp_getcookie('sp_quiz_cookie');
								if(!sp_quiz_cookie) { var arr = [ postid ]; }
								else {
									var arr = JSON.parse(sp_getcookie('sp_quiz_cookie'));
									arr.push( postid );
								}
								document.cookie = encodeURIComponent('sp_quiz_cookie') + "=" + JSON.stringify(arr) + expires + "; path=/";
							}, 500);
						}
						else { // set cookie after the contact form was submitted
							document.addEventListener( 'wpcf7mailsent', function( event ) { // set event listener when the contact form was sent
								setTimeout(function(){
									var sp_quiz_cookie = sp_getcookie('sp_quiz_cookie');
									if(!sp_quiz_cookie) { var arr = [ encodeURIComponent( postid ) ]; }
									else {
										var arr = JSON.parse(sp_getcookie('sp_quiz_cookie'));
										arr.push( encodeURIComponent( postid ) );
									}
									document.cookie = encodeURIComponent('sp_quiz_cookie') + "=" + JSON.stringify(arr) + expires + "; path=/";
								}, 500);
							}, false );
						}
					}
					// add answer-submitted class to wrapper
					$quiz_wrapper.addClass('answer-submitted');
				}
			});
		});

		$( document ).on( 'click', '.spquiz-back', function(event) {
			event.preventDefault();
			this.blur(); // Manually remove focus from clicked link.
			$(this).parent().parent().parent().find('.spquiz-answers').show();
			$(this).parent().parent().html(''); // clears .spquiz-result div
			// adjust iframe height if iframe is used (#sp_main_wrap is only used for iframe)
			if($('#sp_main_wrap').length) {
				var iframe_wrap_height = Math.floor( $('.santapress-post-inner').height() ) + 100;
				$('#sp-iframe', window.parent.document).height(iframe_wrap_height);
				$('.sp-modal-iframe', window.parent.document).height(iframe_wrap_height);
			}
			// remove answer-submitted class from wrapper
			$('.spquiz').removeClass('answer-submitted');
		});

		// helper function to get cookies
		function sp_getcookie(name) {
		    var v = document.cookie.match('(^|;) ?' + name + '=([^;]*)(;|$)');
		    return v ? v[2] : null;
		}

		// stop playing video after closing the modal (since 1.5.0)
		$(document).on($.spmodal.CLOSE, function() {
		    $('.modal iframe').attr('src', '');
		});

	});

})( jQuery );
